#!/bin/bash
rm -rf /var/log/*;
echo "清空日志文件成功"

systemctl stop majora;
systemctl disable majora;
echo "停止并禁用majora服务成功"

if [ "$EUID" -ne 0 ]; then
  echo "请使用root用户执行"
  exit
fi

DIR=$(
  cd "$(dirname "$0")" || exit
  pwd
)

EXEC=${DIR}/majora3
CONF=${DIR}/majora.toml
LOGDIR=$DIR/log
mkdir -p "${LOGDIR}"
CMD="${EXEC} -config $CONF"

echo "$CMD"

cat <<EOF >"/usr/lib/systemd/system/majora.service"
[Unit]
Description=majora service
After=syslog.target network.target network-online.target
Wants=network.target
Requires=network-online.target

[Service]
Type = simple
ExecStart=$CMD
Restart=always
RestartSec=5s
TimeoutStopSec=5
WorkingDirectory=${DIR}

[Install]
WantedBy=multi-user.target
EOF

sudo systemctl daemon-reload

sudo systemctl enable majora

sudo systemctl start majora

sudo systemctl status majora

echo "generate systemd config success."
