import{_ as i,a,b as n}from"./system_settings-D8yB8nBB.js";import{_ as l}from"./plugin-vue_export-helper-DlAUqK2U.js";import{c as e,a as t,o as h}from"./app-Cp8B0-mJ.js";const p={};function r(k,s){return h(),e("div",null,s[0]||(s[0]=[t('<h1 id="高级需求" tabindex="-1"><a class="header-anchor" href="#高级需求"><span>高级需求</span></a></h1><p>majora从开发至今应对过很的客户需求，但是不是所有客户都需要这些偏定制化的功能，所以这里我根据不同的业务场景，梳理这些场景应该如何配置。</p><blockquote><p>自MajoraV3开始，我们将IP池概念抽象出来，故IP池和IP节点映射关系已经融入到系统作为核心功能。可以看到这在V2阶段本章节大量篇幅都在解释如何构建满足目标需求的IP池。 然而此时本章节已经没有这部分内容的表述了</p></blockquote><blockquote><p>当然，majora作为一款产品，不是所有客户需求都可以被满足，因为每一个客户的需求都会引入新的概念，导致其他客户产生心智负担。 此时若客户依然强烈要求某个功能，则应该考虑购买我们的源代码自行改造和定制</p></blockquote><h2 id="二次开发" tabindex="-1"><a class="header-anchor" href="#二次开发"><span>二次开发</span></a></h2><p>大多数深入使用majora的同学，可能都是将majora作为一个底层服务，而在业务侧需要开发相关功能对majora进行包装。 majora的restfulAPI在swagger中有列出</p><blockquote><p>majora自己的前端，也是完全基于本API开发的，如果您希望保持majora的内核，但是重新开发一个新的前端皮肤，则可以基于本API重写前端页面 若希望自己开发前端，则将静态html内容替换到安装包的<code>config/static/</code>目录下即可</p></blockquote><p><a href="/swagger-ui/index.html" target="_blank" rel="noopener noreferrer">API接口文档</a></p><p><img src="'+i+'" alt="API接口文档"></p><h3 id="接口分类" tabindex="-1"><a class="header-anchor" href="#接口分类"><span>接口分类</span></a></h3><p>Majora的所有API具有两个共性</p><ul><li>AdminOnly： 若API标记了AdminOnly，则证明本API只有管理员身份才可以访问</li><li>SupportApiToken：若API标记了SupportApiToken，则当前API可以通过账户对应的APIToken执行调用</li></ul><blockquote><p>若API无上述两个标记，则当前API没有权限检查，任何人可以匿名访问。 APIToken是账户个人中心展示的一个token，他是一个不会变化的token字符串，用户可以将他写入到代码中对majora系统进行操作</p></blockquote><p><img src="'+a+`" alt=""></p><h3 id="webhook" tabindex="-1"><a class="header-anchor" href="#webhook"><span>webhook</span></a></h3><p>用户可能需要基于majora系统的实时数据进行业务逻辑编程，此时majora提供了webhook的功能，可用于订阅majora内部发生的事件， 如下demo用于订阅majora设备的上下线</p><div class="language-groovy line-numbers-mode" data-highlighter="shiki" data-ext="groovy" data-title="groovy" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span style="--shiki-light:#A0A1A7;--shiki-light-font-style:italic;--shiki-dark:#7F848E;--shiki-dark-font-style:italic;">// 您用于接收majora相关事件数据的接口地址，这里假定是钉钉机器人接口</span></span>
<span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">def</span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;"> DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;"> =</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;"> &quot;https://oapi.dingtalk.com/robot/send?access_token=xxxxToken&quot;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">endpointOffline {</span></span>
<span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">    def</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> json </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> new</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> JsonBuilder</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">()</span></span>
<span class="line"><span style="--shiki-light:#A0A1A7;--shiki-light-font-style:italic;--shiki-dark:#7F848E;--shiki-dark-font-style:italic;">    // 拼接相关的数据结构 </span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    json {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        msgtype </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;text&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        text {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">            content </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;设备离线webhook，客户端id： </span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">clientId</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;"> 所在分组: </span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">group</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    }</span></span>
<span class="line"><span style="--shiki-light:#A0A1A7;--shiki-light-font-style:italic;--shiki-dark:#7F848E;--shiki-dark-font-style:italic;">    // 请注意，当您的设备数量非常多的时候（如大于5千个节点），不要使用httpPost，而是使用asyncPost</span></span>
<span class="line"><span style="--shiki-light:#A0A1A7;--shiki-light-font-style:italic;--shiki-dark:#7F848E;--shiki-dark-font-style:italic;">    // 这是因为httpPost将会是单机串行，数据量过大时将会存在请求调用排队挤压，而asyncPost则不会等待http调用返回</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    asyncPost </span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, json</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">endpointOnline {</span></span>
<span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">    def</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> json </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> new</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> JsonBuilder</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">()</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    json {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        msgtype </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;text&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        text {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">            content </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;设备上线webhook，客户端id： </span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">clientId</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;"> 所在分组: </span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">group</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    }</span></span>
<span class="line"><span style="--shiki-light:#A0A1A7;--shiki-light-font-style:italic;--shiki-dark:#7F848E;--shiki-dark-font-style:italic;">    // 请注意，当您的设备数量非常多的时候（如大于5千个节点），不要使用httpPost，而是使用asyncPost</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    asyncPost </span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, json</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div></div></div><h2 id="使用白名单进行鉴权" tabindex="-1"><a class="header-anchor" href="#使用白名单进行鉴权"><span>使用白名单进行鉴权</span></a></h2><p>此功能给无法使用账号密码进行鉴权的场景使用，首先majora的代理服务必须鉴权，鉴权方式支持账号密码和白名单两种。</p><p>当我们的业务场景无法使用账号密码鉴权，而必须使用白名单鉴权时，可能出现一个业务状况：白名单鉴权根据访问代理ip资源的的机器的出口ip来识别请求， 然而这些机器的出口ip可能会发生缓慢的变化。如在程序运行在宽带网络之中、运行在手机4G流量之下。</p><p>由于无法静态确定出口ip，所以我们并不能提前在后台填写ip列表。所以majora提供的解决方案如下：</p><ul><li>majora提供了Http接口API，可以通过API动态添加白名单配置，业务可以定时的、循环的调用API，维护白名单列表</li><li>直接访问对应http接口即可，majora将会自动的解析来源ip（不需要手动访问ip解析网站获得出口ip）</li><li>Http接口存在鉴权（即ApiToken），故不存在安全问题</li><li>为避免配置碰撞，majora使用LRU策略，在白名单配置达到容量的时候，删除最早添加的，且没有心跳的ip白名单配置。保证白名名单存储最近的、最新的内容</li><li>此方案可能在天级别内具备几分钟级别的服务不可用场景，但是整体基本满足需要。</li></ul><h2 id="系统设置" tabindex="-1"><a class="header-anchor" href="#系统设置"><span>系统设置</span></a></h2><p>majora后台有多项配置实现一些功能特定功能设定,这里将部分重要的设置项做一个解释</p><p><img src="`+n+`" alt=""></p><h3 id="是否允许注册用户" tabindex="-1"><a class="header-anchor" href="#是否允许注册用户"><span>是否允许注册用户</span></a></h3><p>majora系统大多运行在公网，可以被互联网直接访问，而不少功能和能力在注册用户后就可以使用，为了避免权限越界。可以在系统部署完成后关闭用户注册功能</p><h3 id="swaggerapi暴露问题" tabindex="-1"><a class="header-anchor" href="#swaggerapi暴露问题"><span>SwaggerAPI暴露问题</span></a></h3><p>majora是一个公开软件，理论上swagger的API说明文档在互联网就是公开可见的，然而当majora在某些公司内部部署时，会被防火墙判定为API说明文档泄漏，进而推导公司机密泄漏 。 这在一些国家机构的服务器环境中尤为常见。为了避免防火墙的报警，你可以在系统设置中关闭两组功能。</p><ul><li>拦截Swagger： swagger说明文档将会404</li><li>拦截Actuator：指标暴露服务将会404（在大多数集团公司中，都具有标准的监控平台，actuator则是标准的监控指标提供服务，此功能可以将majora内部运行指标对接到你们公司的监控平台）</li></ul><h3 id="代理请求访问控制" tabindex="-1"><a class="header-anchor" href="#代理请求访问控制"><span>代理请求访问控制</span></a></h3><p>如果你的国家或者地区有法律要求，客人不允许访问某些特定网站，则可以配置ACL规则对用户的访问行为进行拦截，参考配置如下</p><div class="language-text line-numbers-mode" data-highlighter="shiki" data-ext="text" data-title="text" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span>all:*.baidu.com,*.google.com,www.tencent.com,114.54.34.23,123.434.*;some-user1:*.google.com;some-user2:*.gov.cn</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div></div></div><ul><li>基础规则： user1:rule1;user2:rule2，多个guise用分号<code>;</code>分隔</li><li><code>all</code>:all是一个特殊用户，他的规则对所有用户生效</li><li>每个用户可以配置多个deny规则 <ul><li>*.baidu.com ：以某个域名结尾</li><li>114.54.34.23：一个特性的IP地址</li><li><code>www.tencent.com</code>一个特定的域名</li><li>123.434.* ：限制某个网段</li></ul></li></ul><blockquote><p>ACL 为deny规则，满足规则的代理流量将会被阻断拦截</p></blockquote><h2 id="ssl-over-ssl" tabindex="-1"><a class="header-anchor" href="#ssl-over-ssl"><span>ssl over ssl</span></a></h2><blockquote><p>在V3阶段，ssl能力暂时还没有完全迁移过来，故本功能暂时还不支持，然而此功能自在未来计划的中</p></blockquote><p>在使用https代理的时候，https底层是ssl，即代理报文经过了tls加密，majora并不干预这个加密过程，他只透传tls流量。</p><p>按照https代理的标准流程，存在https客户端到代理网站的流量+https客户端发送给最终的目标网站的加密流量。此时由于目标网站是https的，此流量必须加密。 然而https客户端到代理服务器（即majora服务器）的流量，我们一般认为他是明文的流量。</p><p>不过这是一般情况，按照http代理的标准流程，我们允许http客户端到majora代理服务器的流量进行tls加密，此时如果有中间人抓包则无法看到http客户端发送给majora的报文内容了， 这个场景我把它叫做<code>ssl over ssl</code></p><p>大多数情况此种场景在python代码中容易出现，目前其他语言很少看到出现此种特性：</p><p>如代码：</p><h3 id="普通的-和majora通信使用明文的方式" tabindex="-1"><a class="header-anchor" href="#普通的-和majora通信使用明文的方式"><span>普通的，和majora通信使用明文的方式</span></a></h3><div class="language-python line-numbers-mode" data-highlighter="shiki" data-ext="python" data-title="python" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">import</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> requests</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">proxies </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> {</span></span>
<span class="line"><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">    &#39;http&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">: </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;http://majora:majora@majora.iinti.cn:6879&quot;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">,</span></span>
<span class="line"><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">    &#39;https&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">: </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;http://majora:majora@majora.iinti.cn:6879&quot;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> </span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">res </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> requests.</span><span style="--shiki-light:#383A42;--shiki-dark:#61AFEF;">get</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">(</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&#39;https://www.baidu.com&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, </span><span style="--shiki-light:#986801;--shiki-light-font-style:inherit;--shiki-dark:#E06C75;--shiki-dark-font-style:italic;">timeout</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">11</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, </span><span style="--shiki-light:#986801;--shiki-light-font-style:inherit;--shiki-dark:#E06C75;--shiki-dark-font-style:italic;">proxies</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">proxies).text</span></span>
<span class="line"><span style="--shiki-light:#0184BC;--shiki-dark:#56B6C2;">print</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">(res)</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div></div></div><h3 id="ssloverssl-和majora通信使用tls加密的方式" tabindex="-1"><a class="header-anchor" href="#ssloverssl-和majora通信使用tls加密的方式"><span>SSLOverSSL，和majora通信使用tls加密的方式</span></a></h3><div class="language-python line-numbers-mode" data-highlighter="shiki" data-ext="python" data-title="python" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">import</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> requests</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">proxies </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> {</span></span>
<span class="line"><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">    &#39;http&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">: </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;https://majora:majora@majora.iinti.cn:6879&quot;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">,</span></span>
<span class="line"><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">    &#39;https&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">: </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;https://majora:majora@majora.iinti.cn:6879&quot;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> </span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">res </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> requests.</span><span style="--shiki-light:#383A42;--shiki-dark:#61AFEF;">get</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">(</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&#39;https://www.baidu.com&#39;</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, </span><span style="--shiki-light:#986801;--shiki-light-font-style:inherit;--shiki-dark:#E06C75;--shiki-dark-font-style:italic;">timeout</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">11</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, </span><span style="--shiki-light:#986801;--shiki-light-font-style:inherit;--shiki-dark:#E06C75;--shiki-dark-font-style:italic;">proxies</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">proxies).text</span></span>
<span class="line"><span style="--shiki-light:#0184BC;--shiki-dark:#56B6C2;">print</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">(res)</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div></div></div><p>支持ssl over ssl，则要求majora服务器具备https证书，你需要去ca机构申请证书（由于实在是太麻烦，而且基本没有业务收益，所以其实一般来说不建议用户搞这个），然后配置证书到majora中。</p><h3 id="配置majora证书" tabindex="-1"><a class="header-anchor" href="#配置majora证书"><span>配置majora证书</span></a></h3><ul><li>申请ca证书，放置到majora所在服务器</li><li>如果使用docker，则需要为ca证书文件进行挂载映射，避免重启docker证书消失</li><li>配置<code>application.properties</code><ul><li>server.ssl.keyStore=证书文件地址 (如：ssl_key_store_file.pfx)</li><li>server.ssl.keyStoreType=证书类型 (如：PKCS12)</li><li>server.ssl.keyStorePassword=证书密码</li></ul></li><li>重启majora系统，即可支持<code>&quot;https://majora:majora@majora3.iinti.cn:6879&quot; </code></li></ul><h3 id="自动生成证书" tabindex="-1"><a class="header-anchor" href="#自动生成证书"><span>自动生成证书</span></a></h3><p>如果你没有申请CA证书，但是依然希望使用ssl over ssl，则可以通过majora自动生成签名证书，此时majora作为根证书机构颁发任意网站证书，所以需要用户在自己的电脑上安装majora提供的根证书。 此种场景几乎不可能有需求，所以这里暂时不展开了。</p>`,51)]))}const g=l(p,[["render",r],["__file","02_scene.html.vue"]]),A=JSON.parse('{"path":"/02_advance/02_scene.html","title":"高级需求","lang":"zh-CN","frontmatter":{"description":"高级需求 majora从开发至今应对过很的客户需求，但是不是所有客户都需要这些偏定制化的功能，所以这里我根据不同的业务场景，梳理这些场景应该如何配置。 自MajoraV3开始，我们将IP池概念抽象出来，故IP池和IP节点映射关系已经融入到系统作为核心功能。可以看到这在V2阶段本章节大量篇幅都在解释如何构建满足目标需求的IP池。 然而此时本章节已经没有这...","head":[["link",{"rel":"alternate","hreflang":"en-us","href":"https://github.com/yint-tech/majora-doc/en/02_advance/02_scene.html"}],["meta",{"property":"og:url","content":"https://github.com/yint-tech/majora-doc/02_advance/02_scene.html"}],["meta",{"property":"og:site_name","content":"majora"}],["meta",{"property":"og:title","content":"高级需求"}],["meta",{"property":"og:description","content":"高级需求 majora从开发至今应对过很的客户需求，但是不是所有客户都需要这些偏定制化的功能，所以这里我根据不同的业务场景，梳理这些场景应该如何配置。 自MajoraV3开始，我们将IP池概念抽象出来，故IP池和IP节点映射关系已经融入到系统作为核心功能。可以看到这在V2阶段本章节大量篇幅都在解释如何构建满足目标需求的IP池。 然而此时本章节已经没有这..."}],["meta",{"property":"og:type","content":"article"}],["meta",{"property":"og:locale","content":"zh-CN"}],["meta",{"property":"og:locale:alternate","content":"en-US"}],["meta",{"property":"og:updated_time","content":"2025-07-05T11:43:00.000Z"}],["meta",{"property":"article:modified_time","content":"2025-07-05T11:43:00.000Z"}],["script",{"type":"application/ld+json"},"{\\"@context\\":\\"https://schema.org\\",\\"@type\\":\\"Article\\",\\"headline\\":\\"高级需求\\",\\"image\\":[\\"\\"],\\"dateModified\\":\\"2025-07-05T11:43:00.000Z\\",\\"author\\":[]}"]]},"headers":[{"level":2,"title":"二次开发","slug":"二次开发","link":"#二次开发","children":[{"level":3,"title":"接口分类","slug":"接口分类","link":"#接口分类","children":[]},{"level":3,"title":"webhook","slug":"webhook","link":"#webhook","children":[]}]},{"level":2,"title":"使用白名单进行鉴权","slug":"使用白名单进行鉴权","link":"#使用白名单进行鉴权","children":[]},{"level":2,"title":"系统设置","slug":"系统设置","link":"#系统设置","children":[{"level":3,"title":"是否允许注册用户","slug":"是否允许注册用户","link":"#是否允许注册用户","children":[]},{"level":3,"title":"SwaggerAPI暴露问题","slug":"swaggerapi暴露问题","link":"#swaggerapi暴露问题","children":[]},{"level":3,"title":"代理请求访问控制","slug":"代理请求访问控制","link":"#代理请求访问控制","children":[]}]},{"level":2,"title":"ssl over ssl","slug":"ssl-over-ssl","link":"#ssl-over-ssl","children":[{"level":3,"title":"普通的，和majora通信使用明文的方式","slug":"普通的-和majora通信使用明文的方式","link":"#普通的-和majora通信使用明文的方式","children":[]},{"level":3,"title":"SSLOverSSL，和majora通信使用tls加密的方式","slug":"ssloverssl-和majora通信使用tls加密的方式","link":"#ssloverssl-和majora通信使用tls加密的方式","children":[]},{"level":3,"title":"配置majora证书","slug":"配置majora证书","link":"#配置majora证书","children":[]},{"level":3,"title":"自动生成证书","slug":"自动生成证书","link":"#自动生成证书","children":[]}]}],"git":{"createdTime":1745054819000,"updatedTime":1751715780000,"contributors":[{"name":"iinti_cn","email":"iinti@iinti.cn","commits":3},{"name":"liguobao","email":"codelover@qq.com","commits":1}]},"readingTime":{"minutes":7.81,"words":2343},"filePathRelative":"02_advance/02_scene.md","localizedDate":"2025年4月19日","autoDesc":true}');export{g as comp,A as data};
