import{_ as s,a as i,b as a}from"./system_settings-D8yB8nBB.js";import{_ as n}from"./plugin-vue_export-helper-DlAUqK2U.js";import{c as t,a as l,o}from"./app-Cp8B0-mJ.js";const r={};function h(d,e){return o(),t("div",null,e[0]||(e[0]=[l('<h1 id="advanced-use-cases" tabindex="-1"><a class="header-anchor" href="#advanced-use-cases"><span>Advanced Use Cases</span></a></h1><p>Over time Majora has been adapted to many customer scenarios. Most deployments do not need heavy customization, so this chapter documents how to address the more advanced requests.</p><blockquote><p>Starting with Majora v3, IP pool concepts are first-class citizens, so the configuration described here builds on top of the pool/endpoint mapping that already exists in the product.</p></blockquote><blockquote><p>Not every requirement should turn into a core feature—adding concepts for one customer often increases cognitive load for everyone else. If you need highly tailored behavior, consider licensing the source code for in-house customization.</p></blockquote><h2 id="secondary-development" tabindex="-1"><a class="header-anchor" href="#secondary-development"><span>Secondary Development</span></a></h2><p>Many teams treat Majora as an infrastructure layer and build business logic around it. All REST APIs are documented via Swagger:</p><ul><li>The official frontend is built entirely on these APIs. If you want to retain the core while creating a custom skin, you can re-implement the UI against the same endpoints.</li><li>Deploy your compiled frontend under <code>conf/static/</code> to ship it with the server.</li></ul><p><a href="/swagger-ui/index.html" target="_blank" rel="noopener noreferrer">API Reference</a></p><p><img src="'+s+'" alt=""></p><h3 id="api-conventions" tabindex="-1"><a class="header-anchor" href="#api-conventions"><span>API Conventions</span></a></h3><ul><li><code>AdminOnly</code>: the endpoint can only be called by administrators.</li><li><code>SupportApiToken</code>: the endpoint accepts the user’s API token.</li></ul><blockquote><p>Endpoints without these flags are public. The API token is shown in the user profile; it is stable so you can embed it in code.</p></blockquote><p><img src="'+i+`" alt=""></p><h3 id="webhooks" tabindex="-1"><a class="header-anchor" href="#webhooks"><span>Webhooks</span></a></h3><p>Subscribe to real-time events (for example device online/offline) with webhooks:</p><div class="language-groovy line-numbers-mode" data-highlighter="shiki" data-ext="groovy" data-title="groovy" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">def</span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;"> DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;"> =</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;"> &quot;https://oapi.dingtalk.com/robot/send?access_token=xxxxToken&quot;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">endpointOffline {</span></span>
<span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">    def</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> json </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> new</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> JsonBuilder</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">()</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    json {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        msgtype </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;text&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        text {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">            content </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;Endpoint offline: clientId=</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">clientId</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">, group=</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">group</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    asyncPost </span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, json</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">endpointOnline {</span></span>
<span class="line"><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;">    def</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;"> json </span><span style="--shiki-light:#383A42;--shiki-dark:#56B6C2;">=</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> new</span><span style="--shiki-light:#A626A4;--shiki-dark:#C678DD;"> JsonBuilder</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">()</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    json {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        msgtype </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;text&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        text {</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">            content </span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;Endpoint online: clientId=</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">clientId</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">, group=</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">\${</span><span style="--shiki-light:#383A42;--shiki-dark:#98C379;">group</span><span style="--shiki-light:#CA1243;--shiki-dark:#C678DD;">}</span><span style="--shiki-light:#50A14F;--shiki-dark:#98C379;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">        }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    }</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">    asyncPost </span><span style="--shiki-light:#986801;--shiki-dark:#D19A66;">DD_WEBHOOK</span><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">, json</span></span>
<span class="line"><span style="--shiki-light:#383A42;--shiki-dark:#ABB2BF;">}</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div></div></div><p>Use <code>asyncPost</code> when thousands of nodes are involved to avoid blocking on HTTP calls.</p><h2 id="whitelist-authentication" tabindex="-1"><a class="header-anchor" href="#whitelist-authentication"><span>Whitelist Authentication</span></a></h2><p>Majora supports username/password and IP whitelist authentication. Whitelists are useful when the client cannot present credentials, but the exit IP may change (for example broadband or mobile networks).</p><ul><li>Use the HTTP API to add/remove whitelist entries dynamically.</li><li>The API captures the caller’s source IP automatically; no need to query external services.</li><li>Requests are protected by the API token.</li><li>Majora retains entries using an LRU strategy, removing stale IPs when the capacity limit is reached.</li></ul><p>This approach may lead to brief downtime (minutes) while the whitelist refreshes, but it works well for most scenarios.</p><h2 id="system-settings" tabindex="-1"><a class="header-anchor" href="#system-settings"><span>System Settings</span></a></h2><p>The admin console exposes several important switches:</p><p><img src="`+a+`" alt=""></p><h3 id="user-registration" tabindex="-1"><a class="header-anchor" href="#user-registration"><span>User Registration</span></a></h3><p>If Majora is exposed to the public Internet, disable self-registration to prevent unauthorized access.</p><h3 id="swagger-actuator" tabindex="-1"><a class="header-anchor" href="#swagger-actuator"><span>Swagger &amp; Actuator</span></a></h3><p>Some corporate firewalls flag open API docs as data leaks. You can disable the Swagger UI and Spring Actuator endpoints to avoid alarms.</p><h3 id="access-control-lists" tabindex="-1"><a class="header-anchor" href="#access-control-lists"><span>Access Control Lists</span></a></h3><p>Block access to certain hosts or IP ranges to comply with local regulations:</p><div class="language- line-numbers-mode" data-highlighter="shiki" data-ext="" data-title="" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span>all:*.baidu.com,*.google.com,www.tencent.com,114.54.34.23,123.434.*;some-user1:*.google.com;some-user2:*.gov.cn</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div></div></div><ul><li>Entries are separated by <code>;</code>.</li><li><code>all</code> applies to every user.</li><li>Wildcards support domains (<code>*.baidu.com</code>) and IP segments (<code>123.434.*</code>).</li><li>ACLs are deny rules—matching traffic is blocked.</li></ul><h2 id="ssl-over-ssl-planned" tabindex="-1"><a class="header-anchor" href="#ssl-over-ssl-planned"><span>SSL over SSL (Planned)</span></a></h2><p>HTTPS proxying already tunnels TLS traffic end-to-end. If you also want the connection between the client and Majora to be encrypted (HTTPS over HTTPS), you must configure an HTTPS certificate on the Majora server.</p><p>Steps:</p><ol><li>Obtain a CA-issued certificate.</li><li>Mount the certificate into the container if you use Docker.</li><li>Configure <code>application.properties</code>:<div class="language- line-numbers-mode" data-highlighter="shiki" data-ext="" data-title="" style="--shiki-light:#383A42;--shiki-dark:#abb2bf;--shiki-light-bg:#FAFAFA;--shiki-dark-bg:#282c34;"><pre class="shiki shiki-themes one-light one-dark-pro vp-code"><code><span class="line"><span>server.ssl.keyStore=/path/to/ssl_key_store_file.pfx</span></span>
<span class="line"><span>server.ssl.keyStoreType=PKCS12</span></span>
<span class="line"><span>server.ssl.keyStorePassword=your_password</span></span></code></pre><div class="line-numbers" aria-hidden="true" style="counter-reset:line-number 0;"><div class="line-number"></div><div class="line-number"></div><div class="line-number"></div></div></div></li><li>Restart Majora and use proxy URLs like <code>https://majora:majora@majora3.iinti.cn:6879</code>.</li></ol><p>Majora can also generate self-signed certificates, but clients must install the root CA. This niche scenario is rarely needed and not covered further here.</p>`,37)]))}const u=n(r,[["render",h],["__file","02_scene.html.vue"]]),g=JSON.parse('{"path":"/en/02_advance/02_scene.html","title":"Advanced Use Cases","lang":"en-US","frontmatter":{"description":"Advanced Use Cases Over time Majora has been adapted to many customer scenarios. Most deployments do not need heavy customization, so this chapter documents how to address the m...","head":[["link",{"rel":"alternate","hreflang":"zh-cn","href":"https://github.com/yint-tech/majora-doc/02_advance/02_scene.html"}],["meta",{"property":"og:url","content":"https://github.com/yint-tech/majora-doc/en/02_advance/02_scene.html"}],["meta",{"property":"og:site_name","content":"Majora"}],["meta",{"property":"og:title","content":"Advanced Use Cases"}],["meta",{"property":"og:description","content":"Advanced Use Cases Over time Majora has been adapted to many customer scenarios. Most deployments do not need heavy customization, so this chapter documents how to address the m..."}],["meta",{"property":"og:type","content":"article"}],["meta",{"property":"og:locale","content":"en-US"}],["meta",{"property":"og:locale:alternate","content":"zh-CN"}],["meta",{"property":"og:updated_time","content":"2025-10-15T06:46:18.000Z"}],["meta",{"property":"article:modified_time","content":"2025-10-15T06:46:18.000Z"}],["script",{"type":"application/ld+json"},"{\\"@context\\":\\"https://schema.org\\",\\"@type\\":\\"Article\\",\\"headline\\":\\"Advanced Use Cases\\",\\"image\\":[\\"\\"],\\"dateModified\\":\\"2025-10-15T06:46:18.000Z\\",\\"author\\":[]}"]]},"headers":[{"level":2,"title":"Secondary Development","slug":"secondary-development","link":"#secondary-development","children":[{"level":3,"title":"API Conventions","slug":"api-conventions","link":"#api-conventions","children":[]},{"level":3,"title":"Webhooks","slug":"webhooks","link":"#webhooks","children":[]}]},{"level":2,"title":"Whitelist Authentication","slug":"whitelist-authentication","link":"#whitelist-authentication","children":[]},{"level":2,"title":"System Settings","slug":"system-settings","link":"#system-settings","children":[{"level":3,"title":"User Registration","slug":"user-registration","link":"#user-registration","children":[]},{"level":3,"title":"Swagger & Actuator","slug":"swagger-actuator","link":"#swagger-actuator","children":[]},{"level":3,"title":"Access Control Lists","slug":"access-control-lists","link":"#access-control-lists","children":[]}]},{"level":2,"title":"SSL over SSL (Planned)","slug":"ssl-over-ssl-planned","link":"#ssl-over-ssl-planned","children":[]}],"git":{"createdTime":1760510778000,"updatedTime":1760510778000,"contributors":[{"name":"liguobao","email":"codelover@qq.com","commits":1}]},"readingTime":{"minutes":1.98,"words":593},"filePathRelative":"en/02_advance/02_scene.md","localizedDate":"October 15, 2025","autoDesc":true}');export{u as comp,g as data};
