import{_ as t}from"./plugin-vue_export-helper-DlAUqK2U.js";import{c as o,a,o as i}from"./app-Cp8B0-mJ.js";const n={};function r(s,e){return i(),o("div",null,e[0]||(e[0]=[a('<h1 id="advanced-deployment" tabindex="-1"><a class="header-anchor" href="#advanced-deployment"><span>Advanced Deployment</span></a></h1><p>This chapter explains the Majora runtime layout and how to tune or customize deployments.</p><h2 id="directory-layout" tabindex="-1"><a class="header-anchor" href="#directory-layout"><span>Directory Layout</span></a></h2><p>Majora is written in Java (Spring Boot) with a customized Undertow container. The release package is a compressed directory containing:</p><ul><li><code>bin/</code>: startup scripts that locate the JRE and launch the Spring Boot application.</li><li><code>assets/</code>: database schema (<code>ddl.sql</code>) and the <code>proguard.map</code> file used to de-obfuscate stack traces when working with support.</li><li><code>conf/</code>: editable configuration and runtime assets.</li><li><code>lib/</code>: Java dependencies as well as Majora’s compiled classes.</li><li><code>logs/</code>: runtime logs, including business logs, archived errors, metrics, and console output.</li></ul><p>During runtime, additional files such as licenses and version markers are generated alongside logs.</p><h3 id="configuration-highlights" tabindex="-1"><a class="header-anchor" href="#configuration-highlights"><span>Configuration Highlights</span></a></h3><ul><li><code>conf/application.properties</code>: Spring Boot configuration (web port, database connection, etc.).</li><li><code>conf/auth/</code>: iinti licensing system (authorization logs, machine ID, license ticket).</li><li><code>_build_config.properties</code>: build metadata so you can trace issues back to specific releases.</li><li><code>conf/static/*</code>: frontend assets produced by the React build. You can replace them with your own build to customize the UI. <code>conf/static/majora-doc</code> contains the generated documentation site.</li></ul><h3 id="scripts" tabindex="-1"><a class="header-anchor" href="#scripts"><span>Scripts</span></a></h3><ul><li>Linux: <code>bin/startup.sh</code> detects existing processes and restarts them safely.</li><li>Windows: <code>bin/MajoraV3Main.bat</code> bootstraps the service. Remember that the script itself does not daemonize the process—you need to keep the window open or create a service wrapper.</li></ul><h2 id="distributed-deployment" tabindex="-1"><a class="header-anchor" href="#distributed-deployment"><span>Distributed Deployment</span></a></h2><p>Majora’s single-node performance is high enough for most workloads, so scaling vertically is usually sufficient. If you need high availability, deploy multiple Majora nodes that share the same MySQL instance:</p><ol><li>Install Majora on each server but point them all to one MySQL database so configuration and state stay consistent.</li><li>Ensure the nodes can reach each other over the web port to propagate configuration changes.</li></ol><h3 id="docker-based-ha" tabindex="-1"><a class="header-anchor" href="#docker-based-ha"><span>Docker-Based HA</span></a></h3><p>With Docker or Docker Compose, adopt a <code>1 + N</code> topology (one MySQL container, N Majora containers). Modify the compose file to run a single MySQL service and multiple Majora services. The all-in-one image cannot be used for clustering because MySQL is bundled inside the same container and is not exposed externally.</p><h3 id="client-failover" tabindex="-1"><a class="header-anchor" href="#client-failover"><span>Client Failover</span></a></h3><p>The client supports multiple server addresses:</p><ul><li><strong>Domain-based:</strong> Point the Majora domain to several IPs. The client resolves all addresses and automatically performs failover. Update the DNS records to adjust the server pool.</li><li><strong>Static list:</strong> Specify multiple IP addresses directly in the config.</li></ul><h2 id="docker-concepts-recap" tabindex="-1"><a class="header-anchor" href="#docker-concepts-recap"><span>Docker Concepts Recap</span></a></h2><p>We recommend Docker for most deployments, especially if your team is not focused on Java operations.</p><ul><li><strong>Containers</strong> bundle the full runtime so you can launch Majora with a single command.</li><li><strong>Port mapping</strong> (<code>-p 80:6879</code>, <code>-p 30000-30200:30000-30200</code>) exposes container ports to the host and the outside world.</li><li><strong>Volume mapping</strong> persists important data outside the container: <ul><li>MySQL data: <code>~/majora-mysql-data:/var/lib/mysql</code></li><li>License files: <code>~/majora-iinti-auth:/opt/majora/conf/auth</code></li><li>Logs (optional): map the log directory if you want to inspect logs on the host.</li></ul></li></ul>',21)]))}const d=t(n,[["render",r],["__file","01_deploy_advance.html.vue"]]),p=JSON.parse('{"path":"/en/02_advance/01_deploy_advance.html","title":"Advanced Deployment","lang":"en-US","frontmatter":{"description":"Advanced Deployment This chapter explains the Majora runtime layout and how to tune or customize deployments. Directory Layout Majora is written in Java (Spring Boot) with a cus...","head":[["link",{"rel":"alternate","hreflang":"zh-cn","href":"https://github.com/yint-tech/majora-doc/02_advance/01_deploy_advance.html"}],["meta",{"property":"og:url","content":"https://github.com/yint-tech/majora-doc/en/02_advance/01_deploy_advance.html"}],["meta",{"property":"og:site_name","content":"Majora"}],["meta",{"property":"og:title","content":"Advanced Deployment"}],["meta",{"property":"og:description","content":"Advanced Deployment This chapter explains the Majora runtime layout and how to tune or customize deployments. Directory Layout Majora is written in Java (Spring Boot) with a cus..."}],["meta",{"property":"og:type","content":"article"}],["meta",{"property":"og:locale","content":"en-US"}],["meta",{"property":"og:locale:alternate","content":"zh-CN"}],["meta",{"property":"og:updated_time","content":"2025-10-15T06:46:18.000Z"}],["meta",{"property":"article:modified_time","content":"2025-10-15T06:46:18.000Z"}],["script",{"type":"application/ld+json"},"{\\"@context\\":\\"https://schema.org\\",\\"@type\\":\\"Article\\",\\"headline\\":\\"Advanced Deployment\\",\\"image\\":[\\"\\"],\\"dateModified\\":\\"2025-10-15T06:46:18.000Z\\",\\"author\\":[]}"]]},"headers":[{"level":2,"title":"Directory Layout","slug":"directory-layout","link":"#directory-layout","children":[{"level":3,"title":"Configuration Highlights","slug":"configuration-highlights","link":"#configuration-highlights","children":[]},{"level":3,"title":"Scripts","slug":"scripts","link":"#scripts","children":[]}]},{"level":2,"title":"Distributed Deployment","slug":"distributed-deployment","link":"#distributed-deployment","children":[{"level":3,"title":"Docker-Based HA","slug":"docker-based-ha","link":"#docker-based-ha","children":[]},{"level":3,"title":"Client Failover","slug":"client-failover","link":"#client-failover","children":[]}]},{"level":2,"title":"Docker Concepts Recap","slug":"docker-concepts-recap","link":"#docker-concepts-recap","children":[]}],"git":{"createdTime":1760510778000,"updatedTime":1760510778000,"contributors":[{"name":"liguobao","email":"codelover@qq.com","commits":1}]},"readingTime":{"minutes":1.57,"words":470},"filePathRelative":"en/02_advance/01_deploy_advance.md","localizedDate":"October 15, 2025","autoDesc":true}');export{d as comp,p as data};
