/*!40101 SET NAMES utf8 */;
-- auto generated by yint package builder
-- export date: 2025-05-07 22:18:32
-- please contact iinti_cn(wechat) to get business support

-- create database
create database IF NOT EXISTS majora3;
use majora3;

-- drop table if exist
drop table if exists access_record;
drop table if exists auth_white_ip;
drop table if exists bill_consumer;
drop table if exists bill_endpoint_count;
drop table if exists bill_endpoint_flow_rate;
drop table if exists endpoint;
drop table if exists endpoint_event;
drop table if exists entity_metric0;
drop table if exists entity_metric1;
drop table if exists entity_metric2;
drop table if exists entity_metric3;
drop table if exists metric_day;
drop table if exists metric_hour;
drop table if exists metric_minute;
drop table if exists metric_tag;
drop table if exists proxy_pool;
drop table if exists redial_log;
drop table if exists redial_scheduler;
drop table if exists server_node;
drop table if exists sys_config;
drop table if exists sys_log;
drop table if exists user_info;

-- create tables

CREATE TABLE `access_record`
(
    `id`           bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `user`         varchar(64) NOT NULL COMMENT '对应的账户',
    `target_host`  varchar(64) NOT NULL COMMENT '访问的目标网址',
    `record_time`  varchar(32) NOT NULL COMMENT '结算时间，精确到小时',
    `create_time`  datetime             DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `record_md5`   varchar(64) NOT NULL COMMENT '任务id，用于快速查询',
    `access_count` int(11)     NOT NULL DEFAULT '0' COMMENT '访问次数',
    PRIMARY KEY (`id`),
    UNIQUE KEY `unq_md5` (`record_md5`, `record_time`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户访问日志';

CREATE TABLE `auth_white_ip`
(
    `id`          bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `white_ip`    varchar(50) DEFAULT NULL COMMENT '出口ip',
    `user`        varchar(64) NOT NULL COMMENT '对应的账户',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `comment`     varchar(64) DEFAULT NULL COMMENT '备注',
    `from_api`    tinyint(1)  DEFAULT '0' COMMENT '是否来自API配置',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='出口ip白名单';

CREATE TABLE `bill_consumer`
(
    `id`          bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `user`        varchar(64) DEFAULT NULL COMMENT '账单所属用户',
    `time_key`    varchar(64) NOT NULL COMMENT '对账时间，精确到分钟',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `rate_usage`  bigint(20)  DEFAULT '0' COMMENT '流量用量',
    PRIMARY KEY (`id`),
    KEY `idx_clean` (`create_time`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='流量消费账单';

CREATE TABLE `bill_endpoint_count`
(
    `id`          bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `endpoint`    varchar(64) NOT NULL COMMENT '设备ID',
    `protocol`    varchar(32) DEFAULT '0' COMMENT '代理协议',
    `success`     tinyint(1)  DEFAULT '0' COMMENT '是否成功',
    `time_key`    varchar(64) NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `count`       bigint(20)  DEFAULT '0' COMMENT '发生次数',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`endpoint`, `protocol`, `success`, `time_key`),
    KEY `idx_query` (`endpoint`),
    KEY `idx_clean` (`create_time`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='设备服务次数监控';

CREATE TABLE `bill_endpoint_flow_rate`
(
    `id`          bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `endpoint`    varchar(64) NOT NULL COMMENT '设备ID',
    `direction`   tinyint(4)  NOT NULL DEFAULT '0' COMMENT '流量方向（上行、下行）',
    `time_key`    varchar(64) NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime             DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `rate_usage`  bigint(20)           DEFAULT '0' COMMENT '流量用量',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`endpoint`, `direction`, `time_key`),
    KEY `idx_query` (`endpoint`),
    KEY `idx_clean` (`create_time`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='设备流量监控';

CREATE TABLE `endpoint`
(
    `id`             bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `endpoint_id`    varchar(64)          DEFAULT NULL COMMENT '客户端生产的设备id',
    `last_active`    datetime    NOT NULL COMMENT '最后活跃时间',
    `create_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `out_ip`         varchar(32)          DEFAULT NULL COMMENT '节点出口IP',
    `country`        varchar(45)          DEFAULT '' COMMENT '国家',
    `city`           varchar(45)          DEFAULT '' COMMENT '城市',
    `read_flow`      bigint(20)  NOT NULL DEFAULT '0' COMMENT '上行总流量',
    `write_flow`     bigint(20)  NOT NULL DEFAULT '0' COMMENT '下行总流量',
    `ping_value`     bigint(11)  NOT NULL DEFAULT '0' COMMENT 'ping值（毫秒）',
    `endpoint_group` varchar(32)          DEFAULT NULL COMMENT '分组',
    `support_pty`    tinyint(1)  NOT NULL DEFAULT '0' COMMENT '是否支持远程终端',
    `support_redial` tinyint(1)  NOT NULL DEFAULT '0' COMMENT '是否支持重播',
    `platform`       varchar(32) NOT NULL DEFAULT 'Linux' COMMENT '平台',
    `os_version`     varchar(64)          DEFAULT NULL COMMENT 'os平台',
    `client_version` varchar(32)          DEFAULT NULL COMMENT '客户端版本',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='设备节点';

CREATE TABLE `endpoint_event`
(
    `id`          bigint(20)                                                    NOT NULL AUTO_INCREMENT,
    `endpoint_id` varchar(128)                                                  NOT NULL COMMENT '所属终端',
    `create_time` datetime                                                      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '发生时间',
    `event`       varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '事件消息',
    PRIMARY KEY (`id`),
    KEY `clean` (`create_time`),
    KEY `search` (`endpoint_id`, `create_time`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = latin1 COMMENT ='终端事件';

CREATE TABLE entity_metric0
(
    `id`          bigint(11)   NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `entity_id`   varchar(64)  NOT NULL COMMENT '设备ID',
    `metric_name` varchar(64)  NOT NULL COMMENT '指标名称',
    `tag_data`    varchar(255) NOT NULL COMMENT '纬度分量，json组合',
    `tag_md5`     varchar(64)  NOT NULL COMMENT 'tag自然顺序排序后的md5',
    `time_key`    varchar(64)  NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime   DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `value`       bigint(20) DEFAULT '0' COMMENT '对应值',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`entity_id`, `metric_name`, `time_key`, `tag_md5`),
    KEY `idx_clean` (`create_time`),
    KEY `idx_query` (`entity_id`, `metric_name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='实体监控指标，用于维度分量过多场景（小时一次）';

CREATE TABLE entity_metric1
(
    `id`          bigint(11)   NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `entity_id`   varchar(64)  NOT NULL COMMENT '设备ID',
    `metric_name` varchar(64)  NOT NULL COMMENT '指标名称',
    `tag_data`    varchar(255) NOT NULL COMMENT '纬度分量，json组合',
    `tag_md5`     varchar(64)  NOT NULL COMMENT 'tag自然顺序排序后的md5',
    `time_key`    varchar(64)  NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime   DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `value`       bigint(20) DEFAULT '0' COMMENT '对应值',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`entity_id`, `metric_name`, `time_key`, `tag_md5`),
    KEY `idx_clean` (`create_time`),
    KEY `idx_query` (`entity_id`, `metric_name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='实体监控指标，用于维度分量过多场景（小时一次）';

CREATE TABLE entity_metric2
(
    `id`          bigint(11)   NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `entity_id`   varchar(64)  NOT NULL COMMENT '设备ID',
    `metric_name` varchar(64)  NOT NULL COMMENT '指标名称',
    `tag_data`    varchar(255) NOT NULL COMMENT '纬度分量，json组合',
    `tag_md5`     varchar(64)  NOT NULL COMMENT 'tag自然顺序排序后的md5',
    `time_key`    varchar(64)  NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime   DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `value`       bigint(20) DEFAULT '0' COMMENT '对应值',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`entity_id`, `metric_name`, `time_key`, `tag_md5`),
    KEY `idx_clean` (`create_time`),
    KEY `idx_query` (`entity_id`, `metric_name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='实体监控指标，用于维度分量过多场景（小时一次）';

CREATE TABLE entity_metric3
(
    `id`          bigint(11)   NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `entity_id`   varchar(64)  NOT NULL COMMENT '设备ID',
    `metric_name` varchar(64)  NOT NULL COMMENT '指标名称',
    `tag_data`    varchar(255) NOT NULL COMMENT '纬度分量，json组合',
    `tag_md5`     varchar(64)  NOT NULL COMMENT 'tag自然顺序排序后的md5',
    `time_key`    varchar(64)  NOT NULL COMMENT '对账时间，精确到小时',
    `create_time` datetime   DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `value`       bigint(20) DEFAULT '0' COMMENT '对应值',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`entity_id`, `metric_name`, `time_key`, `tag_md5`),
    KEY `idx_clean` (`create_time`),
    KEY `idx_query` (`entity_id`, `metric_name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='实体监控指标，用于维度分量过多场景（小时一次）';


CREATE TABLE `metric_day`
(
    `id`          bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `name`        varchar(64) NOT NULL COMMENT '指标名称',
    `time_key`    varchar(64) NOT NULL COMMENT '时间索引',
    `tags_md5`    varchar(64) NOT NULL COMMENT '对于tag字段自然顺序拼接求md5',
    `tag1`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag2`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag3`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag4`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag5`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `type`        varchar(8)  NOT NULL COMMENT '指标类型：（counter、gauge、timer，请注意暂时只支持这三种指标）',
    `value`       double      NOT NULL COMMENT '指标值',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`name`, `tags_md5`, `time_key`),
    KEY `idx_query` (`name`, `tags_md5`),
    KEY `idx_delete` (`name`, `create_time`) COMMENT '给删除指标使用'
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='监控指标,天级';

CREATE TABLE `metric_hour`
(
    `id`          bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `name`        varchar(64) NOT NULL COMMENT '指标名称',
    `time_key`    varchar(64) NOT NULL COMMENT '时间索引',
    `tags_md5`    varchar(64) NOT NULL COMMENT '对于tag字段自然顺序拼接求md5',
    `tag1`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag2`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag3`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag4`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag5`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `type`        varchar(8)  NOT NULL COMMENT '指标类型：（counter、gauge、timer，请注意暂时只支持这三种指标）',
    `value`       double      NOT NULL COMMENT '指标值',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`name`, `tags_md5`, `time_key`),
    KEY `idx_query` (`name`, `tags_md5`),
    KEY `idx_delete` (`name`, `create_time`) COMMENT '给删除指标使用'
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='监控指标,小时级';

CREATE TABLE `metric_minute`
(
    `id`          bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `name`        varchar(64) NOT NULL COMMENT '指标名称',
    `time_key`    varchar(64) NOT NULL COMMENT '时间索引',
    `tags_md5`    varchar(64) NOT NULL COMMENT '对于tag字段自然顺序拼接求md5',
    `tag1`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag2`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag3`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag4`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag5`        varchar(64) DEFAULT NULL COMMENT '指标tag',
    `type`        varchar(8)  NOT NULL COMMENT '指标类型：（counter、gauge、timer，请注意暂时只支持这三种指标）',
    `value`       double      NOT NULL COMMENT '指标值',
    `create_time` datetime    DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`name`, `tags_md5`, `time_key`),
    KEY `idx_query` (`name`, `tags_md5`),
    KEY `idx_delete` (`name`, `create_time`) COMMENT '给删除指标使用'
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='监控指标,分钟级';

CREATE TABLE `metric_tag`
(
    `id`        bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `name`      varchar(64) NOT NULL COMMENT '指标名称',
    `tag1_name` varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag2_name` varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag3_name` varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag4_name` varchar(64) DEFAULT NULL COMMENT '指标tag',
    `tag5_name` varchar(64) DEFAULT NULL COMMENT '指标tag',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`name`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='指标tag定义';

CREATE TABLE `proxy_pool`
(
    `id`          bigint(11)  NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `pool_key`    varchar(64)          DEFAULT NULL COMMENT 'ip池key，用于唯一标记一个IP池',
    `pool_desc`   varchar(64) NOT NULL DEFAULT '' COMMENT 'IP池描述',
    `pool_type`   tinyint(4)  NOT NULL DEFAULT '0' COMMENT 'IP池类型（区分随机IP池、静态绑定IP池、一致性哈希IP池）',
    `enabled`     tinyint(1)  NOT NULL DEFAULT '1' COMMENT '是否启用',
    `create_time` datetime             DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `pool_config` text        NOT NULL COMMENT 'IP池配置',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`pool_key`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='代理IP池';

CREATE TABLE `redial_log`
(
    `id`            int(11)                                NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `client_id`     varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '设备id',
    `rule_id`       varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '重播规则',
    `request_time`  datetime                               NOT NULL COMMENT '重播发起时间',
    `response_time` datetime                               NOT NULL COMMENT '重播响应时间',
    `success`       tinyint(1)                             NOT NULL DEFAULT '0' COMMENT '是否成功',
    `response_msg`  varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '重播响应',
    PRIMARY KEY (`id`),
    KEY `redial_log_index_clean` (`request_time`) COMMENT '清理索引',
    KEY `redial_log_index_search` (`rule_id`, `id`) COMMENT '重播日志搜索'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='重播日志';

CREATE TABLE `redial_scheduler`
(
    `id`             bigint(20)                              NOT NULL AUTO_INCREMENT,
    `rule_name`      varchar(64) COLLATE utf8mb4_unicode_ci  NOT NULL COMMENT '规则名称',
    `rule_desc`      varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '规则描述',
    `script_content` text COLLATE utf8mb4_unicode_ci         NOT NULL COMMENT '调度脚本代码',
    `create_time`    datetime                                NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `redial_scheduler_pk_2` (`rule_name`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='重播调度器';

CREATE TABLE `server_node`
(
    `id`               bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `server_id`        varchar(64)  NOT NULL COMMENT '服务器id，唯一标记服务器',
    `last_active_time` datetime              DEFAULT NULL COMMENT '最后心跳时间',
    `create_time`      datetime              DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `ip`               varchar(512) NOT NULL DEFAULT '',
    `port`             int(11)      NOT NULL COMMENT 'springboot 服务开启端口',
    `enable`           tinyint(1)   NOT NULL DEFAULT '1' COMMENT '服务器是否启用',
    `local_ip`         varchar(512)          DEFAULT NULL COMMENT '本地IP',
    `out_ip`           varchar(512)          DEFAULT NULL COMMENT '工作ip',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`server_id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='服务器节点，多台服务器组成代理集群';

CREATE TABLE `sys_config`
(
    `id`             bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `config_comment` varchar(128)  DEFAULT NULL COMMENT '配置备注',
    `config_key`     varchar(64)   DEFAULT NULL COMMENT 'key',
    `config_value`   varchar(1024) DEFAULT NULL COMMENT 'value',
    `create_time`    datetime      DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uniq_record` (`config_comment`, `config_key`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='系统配置';

CREATE TABLE `sys_log`
(
    `id`          bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增主键',
    `username`    varchar(100)    DEFAULT NULL COMMENT '操作用户名',
    `operation`   varchar(200)    DEFAULT NULL COMMENT '操作',
    `params`      varchar(500)    DEFAULT NULL COMMENT ' 操作参数',
    `method_name` varchar(200)    DEFAULT NULL COMMENT '操作的方法名',
    `create_time` timestamp  NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户访问日志';

CREATE TABLE `user_info`
(
    `id`           bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增主建',
    `user_name`    varchar(64)         DEFAULT NULL COMMENT '用户名',
    `password`     varchar(64)         DEFAULT NULL COMMENT '密码',
    `last_active`  datetime   NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后登陆时间',
    `create_time`  datetime            DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `login_token`  varchar(64)         DEFAULT NULL COMMENT '登录token',
    `api_token`    varchar(64)         DEFAULT '' COMMENT 'api 访问token',
    `is_admin`     tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是管理员',
    `update_time`  timestamp  NULL     DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
    `permission`   varchar(2048)       DEFAULT '' COMMENT '用户权限',
    `auth_account` varchar(64)         DEFAULT NULL COMMENT '代理鉴权账户',
    `auth_pwd`     varchar(64)         DEFAULT NULL COMMENT '代理鉴权密码',
    `rate_usage`   bigint(20)          DEFAULT '0' COMMENT '本用户代理消耗总流量',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户信息';

