@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  MajoraV3Main startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and MAJORA_V3_MAIN_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-Dfile.encoding=utf-8" "-Duser.timezone=GMT+08" "-XX:-OmitStackTraceInFastThrow"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH. 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME% 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\conf;%APP_HOME%\lib\majora-server-3.0-plain.jar;%APP_HOME%\lib\spring-boot-starter-web-3.2.5.jar;%APP_HOME%\lib\undertow-gateway-1.3.jar;%APP_HOME%\lib\jakarta.servlet-api-5.0.0.jar;%APP_HOME%\lib\spring-boot-starter-aop-3.2.5.jar;%APP_HOME%\lib\spring-boot-starter-actuator-3.2.5.jar;%APP_HOME%\lib\spring-boot-starter-validation-3.2.5.jar;%APP_HOME%\lib\mybatis-plus-spring-boot3-starter-3.5.6.jar;%APP_HOME%\lib\groovy-json-4.0.23.jar;%APP_HOME%\lib\groovy-4.0.23.jar;%APP_HOME%\lib\mysql-connector-java-8.0.28.jar;%APP_HOME%\lib\springdoc-openapi-starter-webmvc-ui-2.5.0.jar;%APP_HOME%\lib\spring-boot-starter-json-3.2.5.jar;%APP_HOME%\lib\spring-boot-starter-jdbc-3.2.5.jar;%APP_HOME%\lib\spring-boot-starter-3.2.5.jar;%APP_HOME%\lib\spring-boot-starter-logging-3.2.5.jar;%APP_HOME%\lib\logback-classic-1.4.12.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.30.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.30.jar;%APP_HOME%\lib\majora-sdk-1.0.jar;%APP_HOME%\lib\guava-31.1-jre.jar;%APP_HOME%\lib\springdoc-openapi-starter-webmvc-api-2.5.0.jar;%APP_HOME%\lib\springdoc-openapi-starter-common-2.5.0.jar;%APP_HOME%\lib\swagger-core-jakarta-2.2.21.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\commons-io-2.10.0.jar;%APP_HOME%\lib\fastjson-1.2.79.jar;%APP_HOME%\lib\netty-codec-http-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.60.Final.jar;%APP_HOME%\lib\bcpkix-jdk15on-1.55.jar;%APP_HOME%\lib\bcprov-jdk15on-1.55.jar;%APP_HOME%\lib\poi-ooxml-3.11.jar;%APP_HOME%\lib\geoip2-4.2.0.jar;%APP_HOME%\lib\geohash-1.4.0.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.15.4.jar;%APP_HOME%\lib\spring-boot-actuator-autoconfigure-3.2.5.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.15.4.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.15.4.jar;%APP_HOME%\lib\jackson-core-2.15.4.jar;%APP_HOME%\lib\swagger-models-jakarta-2.2.21.jar;%APP_HOME%\lib\jackson-annotations-2.15.4.jar;%APP_HOME%\lib\jackson-module-parameter-names-2.15.4.jar;%APP_HOME%\lib\jackson-databind-2.15.4.jar;%APP_HOME%\lib\spring-boot-autoconfigure-3.2.5.jar;%APP_HOME%\lib\spring-boot-actuator-3.2.5.jar;%APP_HOME%\lib\spring-boot-3.2.5.jar;%APP_HOME%\lib\spring-webmvc-6.1.6.jar;%APP_HOME%\lib\spring-web-6.1.6.jar;%APP_HOME%\lib\jakarta.annotation-api-2.1.1.jar;%APP_HOME%\lib\hibernate-validator-8.0.1.Final.jar;%APP_HOME%\lib\jboss-logging-3.5.3.Final.jar;%APP_HOME%\lib\jboss-logging-annotations-3.0.1.Final.jar;%APP_HOME%\lib\spring-context-6.1.6.jar;%APP_HOME%\lib\spring-aop-6.1.6.jar;%APP_HOME%\lib\aspectjweaver-1.9.22.jar;%APP_HOME%\lib\micrometer-jakarta9-1.12.5.jar;%APP_HOME%\lib\micrometer-core-1.12.5.jar;%APP_HOME%\lib\micrometer-observation-1.12.5.jar;%APP_HOME%\lib\tomcat-embed-el-10.1.20.jar;%APP_HOME%\lib\mybatis-plus-3.5.6.jar;%APP_HOME%\lib\mybatis-spring-3.0.3.jar;%APP_HOME%\lib\mybatis-plus-spring-boot-autoconfigure-3.5.6.jar;%APP_HOME%\lib\protobuf-java-3.11.4.jar;%APP_HOME%\lib\swagger-ui-5.13.0.jar;%APP_HOME%\lib\logback-core-1.4.14.jar;%APP_HOME%\lib\HikariCP-5.0.1.jar;%APP_HOME%\lib\log4j-to-slf4j-2.21.1.jar;%APP_HOME%\lib\jul-to-slf4j-2.0.13.jar;%APP_HOME%\lib\slf4j-api-2.0.13.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-3.12.0.jar;%APP_HOME%\lib\error_prone_annotations-2.11.0.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\jsoup-1.15.3.jar;%APP_HOME%\lib\netty-handler-4.1.109.Final.jar;%APP_HOME%\lib\netty-codec-4.1.109.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.109.Final.jar;%APP_HOME%\lib\netty-transport-4.1.109.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.109.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.109.Final.jar;%APP_HOME%\lib\netty-common-4.1.109.Final.jar;%APP_HOME%\lib\poi-3.11.jar;%APP_HOME%\lib\poi-ooxml-schemas-3.11.jar;%APP_HOME%\lib\maxmind-db-3.1.0.jar;%APP_HOME%\lib\spring-jdbc-6.1.6.jar;%APP_HOME%\lib\spring-tx-6.1.6.jar;%APP_HOME%\lib\spring-beans-6.1.6.jar;%APP_HOME%\lib\spring-expression-6.1.6.jar;%APP_HOME%\lib\spring-core-6.1.6.jar;%APP_HOME%\lib\snakeyaml-2.2.jar;%APP_HOME%\lib\micrometer-commons-1.12.5.jar;%APP_HOME%\lib\jakarta.validation-api-3.0.2.jar;%APP_HOME%\lib\classmate-1.6.0.jar;%APP_HOME%\lib\mybatis-plus-extension-3.5.6.jar;%APP_HOME%\lib\mybatis-plus-core-3.5.6.jar;%APP_HOME%\lib\mybatis-plus-annotation-3.5.6.jar;%APP_HOME%\lib\mybatis-3.5.16.jar;%APP_HOME%\lib\jsqlparser-4.9.jar;%APP_HOME%\lib\commons-codec-1.16.1.jar;%APP_HOME%\lib\xmlbeans-2.6.0.jar;%APP_HOME%\lib\spring-jcl-6.1.6.jar;%APP_HOME%\lib\HdrHistogram-2.1.12.jar;%APP_HOME%\lib\LatencyUtils-2.0.3.jar;%APP_HOME%\lib\stax-api-1.0.1.jar;%APP_HOME%\lib\log4j-api-2.21.1.jar;%APP_HOME%\lib\swagger-annotations-jakarta-2.2.21.jar;%APP_HOME%\lib\jakarta.xml.bind-api-4.0.2.jar;%APP_HOME%\lib\jakarta.activation-api-2.1.3.jar


@rem Execute MajoraV3Main
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %MAJORA_V3_MAIN_OPTS%  -classpath "%CLASSPATH%" cn.iinti.majora3.MajoraV3Main %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable MAJORA_V3_MAIN_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%MAJORA_V3_MAIN_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
