#!/bin/bash

# 定义日志函数
log() {
    echo "[INFO] $(date '+%Y-%m-%d %H:%M:%S') - $1"
}

# 
log "Get PPPoE IP Address"
current_ip=$(ifconfig ppp0 | grep 'inet ' | awk '{print $2}')

# pri
if [ -n "$current_ip" ]; then
    log "redial ip: $current_ip"
else
    log "ip not found, maybe network not work."
fi

# 执行拨号断开
log "正在执行 pppoe-stop 断开连接..."
pppoe-stop
if [ $? -eq 0 ]; then
    log "pppoe-stop 成功执行。"
else
    log "pppoe-stop 执行失败。"
fi

# 断开后等待一段时间，确保连接完全断开
log "等待 2 秒，确保连接断开..."
sleep 2

# 执行拨号连接
log "正在执行 pppoe-start 重拨连接..."
pppoe-start
if [ $? -eq 0 ]; then
    log "pppoe-start 成功执行。"
else
    log "pppoe-start 执行失败。"
fi

# 等待 5 秒，确保连接已建立
log "等待 5 秒，确保连接建立..."
sleep 5

# 获取拨号后的 IP 地址
log "获取拨号后的 IP 地址..."
new_ip=$(ifconfig ppp0 | grep 'inet ' | awk '{print $2}')

if [ -n "$new_ip" ]; then
    log "重拨后的 IP 地址: $new_ip"
else
    log "未检测到重拨后的 IP 地址，可能连接失败或接口名称不同。"
fi

log "重拨操作完成。"