package cn.iinti.majora3.adr

import android.annotation.SuppressLint
import android.app.Application
import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.graphics.Color
import android.net.ConnectivityManager
import android.net.Network
import androidx.core.content.edit
import androidx.lifecycle.MutableLiveData
import com.topjohnwu.superuser.Shell
import com.topjohnwu.superuser.ShellUtils
import kotlinx.coroutines.DelicateCoroutinesApi

lateinit var majora3App: Majora3App
const val TAG = "Majora3"

class Majora3App : Application() {

    val hasNetwork = MutableLiveData(false)

    @OptIn(DelicateCoroutinesApi::class)
    @SuppressLint("WrongConstant")
    override fun onCreate() {
        super.onCreate()

        majora3App = this

        registerNetworkListener()

        //安卓的通知渠道
        setNotifyChannel(this)
        KeepAliveService.startService(this)

        // 启动客户端
        hasNetwork.observeForever {
            ensureMajorClient()
        }

        // Set settings before the main shell can be created
        Shell.enableVerboseLogging = BuildConfig.DEBUG;
        // 任意执行一个命令，用于探测是否支持su
        ShellUtils.fastCmd("pwd")
    }


    private fun setNotifyChannel(context: Context) {
        val notificationChannel = NotificationChannel(
            BuildConfig.APPLICATION_ID,
            "majora3", NotificationManager.IMPORTANCE_HIGH
        )
        notificationChannel.enableLights(true)
        notificationChannel.lightColor = Color.YELLOW
        notificationChannel.setShowBadge(true)
        notificationChannel.lockscreenVisibility = Notification.VISIBILITY_PUBLIC
        val manager = context.getSystemService(NOTIFICATION_SERVICE) as NotificationManager
        manager.createNotificationChannel(notificationChannel)
    }


    private fun registerNetworkListener() {
        val connectivityManager =
            getSystemService(CONNECTIVITY_SERVICE) as ConnectivityManager

        connectivityManager.registerDefaultNetworkCallback(object :
            ConnectivityManager.NetworkCallback() {
            override fun onAvailable(network: Network) {
                hasNetwork.postValue(true)
            }
        })
    }
}