/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.HashMap;
import java.util.Map;

public abstract class Option<T> {
    static final Map<Class<?>, ValueParser<?>> parsers;
    static final ValueParser<?> noParser;

    static <T> ValueParser<Class<? extends T>> getClassParser(final Class<T> clazz) {
        return new ValueParser<Class<? extends T>>(){

            @Override
            public Class<? extends T> parseValue(String string, ClassLoader classLoader) {
                try {
                    return Class.forName(string, false, classLoader).asSubclass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException(String.format("Class %s not found", clazz.getName()), classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException(String.format("Class %s is not an instance of %s", string, clazz));
                }
            }
        };
    }

    static <T, E extends Enum<E>> ValueParser<T> getEnumParser(final Class<T> clazz) {
        return new ValueParser<T>(){

            @Override
            public T parseValue(String string, ClassLoader classLoader) {
                return clazz.cast(Enum.valueOf(Option.asEnum(clazz), string.trim()));
            }
        };
    }

    private static <T, E extends Enum<E>> Class<E> asEnum(Class<T> clazz) {
        return clazz;
    }

    public static <T> ValueParser<T> getParser(Class<T> object) {
        if (((Class)object).isEnum()) {
            return Option.getEnumParser(object);
        }
        if ((object = parsers.get(object)) == null) {
            return noParser;
        }
        return object;
    }

    public abstract T parseValue(String var1, ClassLoader var2);

    static {
        noParser = new ValueParser<Object>(){

            @Override
            public Object parseValue(String string, ClassLoader classLoader) {
                throw new IllegalArgumentException("No parser for this option value type");
            }
        };
        HashMap hashMap = new HashMap();
        hashMap.put(Byte.class, new ValueParser<Byte>(){

            @Override
            public Byte parseValue(String string, ClassLoader classLoader) {
                return Byte.decode(string.trim());
            }
        });
        hashMap.put(Short.class, new ValueParser<Short>(){

            @Override
            public Short parseValue(String string, ClassLoader classLoader) {
                return Short.decode(string.trim());
            }
        });
        hashMap.put(Integer.class, new ValueParser<Integer>(){

            @Override
            public Integer parseValue(String string, ClassLoader classLoader) {
                return Integer.decode(string.trim());
            }
        });
        hashMap.put(Long.class, new ValueParser<Long>(){

            @Override
            public Long parseValue(String string, ClassLoader classLoader) {
                return Long.decode(string.trim());
            }
        });
        hashMap.put(String.class, new ValueParser<String>(){

            @Override
            public String parseValue(String string, ClassLoader classLoader) {
                return string.trim();
            }
        });
        hashMap.put(Boolean.class, new ValueParser<Boolean>(){

            @Override
            public Boolean parseValue(String string, ClassLoader classLoader) {
                return Boolean.valueOf(string.trim());
            }
        });
        parsers = hashMap;
    }

    protected static interface ValueParser<T> {
        public T parseValue(String var1, ClassLoader var2);
    }
}

