/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet;

import io.undertow.servlet.UndertowServletLogger;
import jakarta.servlet.UnavailableException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class UndertowServletLogger_$logger
extends DelegatingBasicLogger
implements UndertowServletLogger,
Serializable,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowServletLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public UndertowServletLogger_$logger(Logger logger2) {
        super(logger2);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void stoppingServletDueToPermanentUnavailability(String string, UnavailableException unavailableException) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)unavailableException, this.stoppingServletDueToPermanentUnavailability$str(), (Object)string);
    }

    protected String stoppingServletDueToPermanentUnavailability$str() {
        return "UT015002: Stopping servlet %s due to permanent unavailability";
    }

    @Override
    public final void stoppingServletUntilDueToTemporaryUnavailability(String string, Date date, UnavailableException unavailableException) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)unavailableException, this.stoppingServletUntilDueToTemporaryUnavailability$str(), (Object)string, (Object)date);
    }

    protected String stoppingServletUntilDueToTemporaryUnavailability$str() {
        return "UT015003: Stopping servlet %s till %s due to temporary unavailability";
    }

    @Override
    public final void errorInvokingListener(String string, Class<?> clazz, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.errorInvokingListener$str(), (Object)string, clazz);
    }

    protected String errorInvokingListener$str() {
        return "UT015005: Error invoking method %s on listener %s";
    }

    @Override
    public final void ioExceptionDispatchingAsyncEvent(IOException iOException) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)iOException, this.ioExceptionDispatchingAsyncEvent$str(), new Object[0]);
    }

    protected String ioExceptionDispatchingAsyncEvent$str() {
        return "UT015006: IOException dispatching async event";
    }

    @Override
    public final void servletStackTracesAll(String string) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.servletStackTracesAll$str(), (Object)string);
    }

    protected String servletStackTracesAll$str() {
        return "UT015007: Stack trace on error enabled for deployment %s, please do not enable for production use";
    }

    @Override
    public final void failedtoLoadPersistentSessions(Exception exception) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)exception, this.failedtoLoadPersistentSessions$str(), new Object[0]);
    }

    protected String failedtoLoadPersistentSessions$str() {
        return "UT015008: Failed to load development mode persistent sessions";
    }

    @Override
    public final void failedToPersistSessionAttribute(String string, Object object, String string2, Exception exception) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)exception, this.failedToPersistSessionAttribute$str(), (Object)string, object, (Object)string2);
    }

    protected String failedToPersistSessionAttribute$str() {
        return "UT015009: Failed to persist session attribute %s with value %s for session %s";
    }

    @Override
    public final void failedToPersistSessions(Exception exception) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)exception, this.failedToPersistSessions$str(), new Object[0]);
    }

    protected String failedToPersistSessions$str() {
        return "UT015010: Failed to persist sessions";
    }

    @Override
    public final void errorGeneratingErrorPage(String string, Object object, int n, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.errorGeneratingErrorPage$str(), (Object)string, object, (Object)n);
    }

    protected String errorGeneratingErrorPage$str() {
        return "UT015012: Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.";
    }

    @Override
    public final void errorReadingRewriteConfiguration(IOException iOException) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)iOException, this.errorReadingRewriteConfiguration$str(), new Object[0]);
    }

    protected String errorReadingRewriteConfiguration$str() {
        return "UT015014: Error reading rewrite configuration";
    }

    protected String invalidRewriteConfiguration$str() {
        return "UT015015: Error reading rewrite configuration: %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteConfiguration(String object) {
        object = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteConfiguration$str(), object));
        UndertowServletLogger_$logger._copyStackTraceMinusOne((Throwable)object);
        return object;
    }

    private static void _copyStackTraceMinusOne(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        throwable.setStackTrace(Arrays.copyOfRange(stackTraceElementArray, 1, stackTraceElementArray.length));
    }

    protected String invalidRewriteMap$str() {
        return "UT015016: Invalid rewrite map class: %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteMap(String object) {
        object = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteMap$str(), object));
        UndertowServletLogger_$logger._copyStackTraceMinusOne((Throwable)object);
        return object;
    }

    protected String invalidRewriteFlags2$str() {
        return "UT015017: Error reading rewrite flags in line %s as %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String object, String string) {
        object = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteFlags2$str(), object, string));
        UndertowServletLogger_$logger._copyStackTraceMinusOne((Throwable)object);
        return object;
    }

    protected String invalidRewriteFlags1$str() {
        return "UT015018: Error reading rewrite flags in line %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String object) {
        object = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteFlags1$str(), object));
        UndertowServletLogger_$logger._copyStackTraceMinusOne((Throwable)object);
        return object;
    }

    @Override
    public final void failedToDestroy(Object object, Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failedToDestroy$str(), object);
    }

    protected String failedToDestroy$str() {
        return "UT015019: Failed to destroy %s";
    }

    @Override
    public final void unsecuredMethodsOnPath(String string, Set<String> set) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsecuredMethodsOnPath$str(), (Object)string, set);
    }

    protected String unsecuredMethodsOnPath$str() {
        return "UT015020: Path %s is secured for some HTTP methods, however it is not secured for %s";
    }

    @Override
    public final void failureDispatchingAsyncEvent(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, this.failureDispatchingAsyncEvent$str(), new Object[0]);
    }

    protected String failureDispatchingAsyncEvent$str() {
        return "UT015021: Failure dispatching async event";
    }
}

