/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.gateway.springboot.web.servlet;

import io.undertow.Undertow;
import io.undertow.gateway.GatewayHandler;
import io.undertow.gateway.springboot.web.embed.UndertowBuilderCustomizer;
import io.undertow.gateway.springboot.web.embed.UndertowDeploymentInfoCustomizer;
import io.undertow.gateway.springboot.web.embed.UndertowServletWebServerFactory;
import io.undertow.gateway.springboot.web.servlet.UndertowServletWebServerFactoryCustomizer;
import jakarta.servlet.Servlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Servlet.class, Undertow.class, GatewayHandler.class})
@ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
public class EmbeddedUndertow {
    @Bean
    UndertowServletWebServerFactory undertowServletWebServerFactory(ObjectProvider<UndertowDeploymentInfoCustomizer> objectProvider, ObjectProvider<UndertowBuilderCustomizer> objectProvider2) {
        UndertowServletWebServerFactory undertowServletWebServerFactory = new UndertowServletWebServerFactory();
        undertowServletWebServerFactory.getDeploymentInfoCustomizers().addAll(objectProvider.orderedStream().toList());
        undertowServletWebServerFactory.getBuilderCustomizers().addAll(objectProvider2.orderedStream().toList());
        return undertowServletWebServerFactory;
    }

    @Bean
    UndertowServletWebServerFactoryCustomizer undertowServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        return new UndertowServletWebServerFactoryCustomizer(serverProperties);
    }
}

