/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.gateway.springboot.web.embed;

import cn.iinti.majora3.0O.OoOoOooOoOoOOo.oOoOOoOo;
import cn.iinti.majora3.0O.oOOoOooOoOoOOo.OooOoOOo;
import io.undertow.Oo;
import io.undertow.OooOOo;
import io.undertow.Undertow;
import io.undertow.gateway.GatewayHandler;
import io.undertow.gateway.springboot.web.embed.AccessLogHttpHandlerFactory;
import io.undertow.gateway.springboot.web.embed.HttpHandlerFactory;
import io.undertow.gateway.springboot.web.embed.SslBuilderCustomizer;
import io.undertow.gateway.springboot.web.embed.UndertowBuilderCustomizer;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class UndertowWebServerFactoryDelegate {
    private Set<UndertowBuilderCustomizer> builderCustomizers = new LinkedHashSet<UndertowBuilderCustomizer>();
    private Integer bufferSize;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;
    private File accessLogDirectory;
    private String accessLogPattern;
    private String accessLogPrefix;
    private String accessLogSuffix;
    private boolean accessLogEnabled = false;
    private boolean accessLogRotate = true;
    private boolean useForwardHeaders;

    UndertowWebServerFactoryDelegate() {
    }

    void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> collection) {
        Assert.notNull(collection, (String)"Customizers must not be null");
        this.builderCustomizers = new LinkedHashSet<UndertowBuilderCustomizer>(collection);
    }

    void addBuilderCustomizers(UndertowBuilderCustomizer ... undertowBuilderCustomizerArray) {
        Assert.notNull((Object)undertowBuilderCustomizerArray, (String)"Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(undertowBuilderCustomizerArray));
    }

    Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    void setBufferSize(Integer n) {
        this.bufferSize = n;
    }

    void setIoThreads(Integer n) {
        this.ioThreads = n;
    }

    void setWorkerThreads(Integer n) {
        this.workerThreads = n;
    }

    void setUseDirectBuffers(Boolean bl) {
        this.directBuffers = bl;
    }

    void setAccessLogDirectory(File file) {
        this.accessLogDirectory = file;
    }

    void setAccessLogPattern(String string) {
        this.accessLogPattern = string;
    }

    void setAccessLogPrefix(String string) {
        this.accessLogPrefix = string;
    }

    String getAccessLogPrefix() {
        return this.accessLogPrefix;
    }

    void setAccessLogSuffix(String string) {
        this.accessLogSuffix = string;
    }

    void setAccessLogEnabled(boolean bl) {
        this.accessLogEnabled = bl;
    }

    boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    void setAccessLogRotate(boolean bl) {
        this.accessLogRotate = bl;
    }

    void setUseForwardHeaders(boolean bl) {
        this.useForwardHeaders = bl;
    }

    boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void addProtocols(GatewayHandler.ProtocolMatcher[] protocolMatcherArray) {
    }

    Undertow.oO createBuilder(AbstractConfigurableWebServerFactory object, Supplier<SslBundle> object22) {
        Http2 http2;
        InetAddress inetAddress = object.getAddress();
        int n = object.getPort();
        Undertow.oO oO2 = Undertow.builder();
        if (this.bufferSize != null) {
            oO2.oO(this.bufferSize);
        }
        if (this.ioThreads != null) {
            oO2.Oo(this.ioThreads);
        }
        if (this.workerThreads != null) {
            oO2.oOOo(this.workerThreads);
        }
        if (this.directBuffers != null) {
            oO2.oO(this.directBuffers);
        }
        if ((http2 = object.getHttp2()) != null) {
            oO2.oO(OooOOo.OooOoOOo, Boolean.valueOf(http2.isEnabled()));
        }
        if (Ssl.isEnabled((Ssl)(http2 = object.getSsl()))) {
            new SslBuilderCustomizer(object.getPort(), inetAddress, http2.getClientAuth(), (SslBundle)object22.get()).customize(oO2);
        } else {
            oO2.oO(n, inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0");
        }
        oO2.oO(OooOOo.oOOooOOo, Integer.valueOf(0));
        for (UndertowBuilderCustomizer undertowBuilderCustomizer : this.builderCustomizers) {
            undertowBuilderCustomizer.customize(oO2);
        }
        return oO2;
    }

    List<HttpHandlerFactory> createHttpHandlerFactories(AbstractConfigurableWebServerFactory object, HttpHandlerFactory ... httpHandlerFactoryArray) {
        object = UndertowWebServerFactoryDelegate.createHttpHandlerFactories(object.getCompression(), this.useForwardHeaders, object.getServerHeader(), object.getShutdown(), httpHandlerFactoryArray);
        if (this.isAccessLogEnabled()) {
            object.add(new AccessLogHttpHandlerFactory(this.accessLogDirectory, this.accessLogPattern, this.accessLogPrefix, this.accessLogSuffix, this.accessLogRotate));
        }
        return object;
    }

    static List<HttpHandlerFactory> createHttpHandlerFactories(Compression object, boolean bl, String string, Shutdown shutdown, HttpHandlerFactory ... httpHandlerFactoryArray) {
        object = new ArrayList<HttpHandlerFactory>(Arrays.asList(httpHandlerFactoryArray));
        if (bl) {
            object.add(Oo::Oo);
        }
        if (StringUtils.hasText((String)string)) {
            object.add(object2 -> {
                OooOoOOo oooOoOOo = object2;
                String string = string;
                object2 = "Server";
                string = oooOoOOo;
                return new oOoOOoOo((OooOoOOo)((Object)string), (String)((Object)object2), string);
            });
        }
        if (shutdown == Shutdown.GRACEFUL) {
            object.add(Oo::oO);
        }
        return object;
    }
}

