/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.gateway.springboot.web.embed;

import cn.iinti.majora3.0O.OoOoOooOoOoOOo.OoOo;
import cn.iinti.majora3.0O.oOOoOooOoOoOOo.OooOoOOo;
import cn.iinti.majora3.0O.oOOoOooOoOoOOo.oOOooOOo;
import cn.iinti.majora3.0O.oOoOOoOooOOo.OoOooOoOoOOo;
import cn.iinti.majora3.0O.oOoOOoOooOOo.oOOoOoOoOo;
import io.undertow.Undertow;
import io.undertow.gateway.springboot.web.embed.HttpHandlerFactory;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class UndertowWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(UndertowWebServer.class);
    private final AtomicReference<GracefulShutdownCallback> gracefulShutdownCallback = new AtomicReference();
    private final Object monitor = new Object();
    private final Undertow.oO builder;
    private final Iterable<HttpHandlerFactory> httpHandlerFactories;
    private final boolean autoStart;
    private Undertow undertow;
    private volatile boolean started = false;
    private volatile OoOo gracefulShutdown;
    private volatile List<Closeable> closeables;

    public UndertowWebServer(Undertow.oO oO2, boolean bl) {
        this(oO2, Collections.singleton(new CloseableHttpHandlerFactory(null)), bl);
    }

    public UndertowWebServer(Undertow.oO oO2, Iterable<HttpHandlerFactory> iterable, boolean bl) {
        this.builder = oO2;
        this.httpHandlerFactories = iterable;
        this.autoStart = bl;
    }

    public void start() {
        Object object2 = this.monitor;
        synchronized (object2) {
            if (this.started) {
                return;
            }
            try {
                if (!this.autoStart) {
                    return;
                }
                if (this.undertow == null) {
                    this.undertow = this.createUndertowServer();
                }
                this.undertow.start();
                this.started = true;
                String string = this.getStartLogMessage();
                logger.info((Object)string);
            }
            catch (Exception exception) {
                try {
                    PortInUseException.ifPortBindingException((Exception)exception, object -> {
                        object = this.getConfiguredPorts();
                        object.removeAll(this.getActualPorts());
                        if (object.size() == 1) {
                            throw new PortInUseException(((Port)object.get(0)).getNumber());
                        }
                    });
                    throw new WebServerException("Unable to start embedded Undertow", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    this.destroySilently();
                    throw throwable;
                }
            }
            return;
        }
    }

    private void destroySilently() {
        try {
            if (this.undertow != null) {
                this.undertow.stop();
                this.closeables.forEach(this::closeSilently);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void closeSilently(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private Undertow createUndertowServer() {
        this.closeables = new ArrayList<Closeable>();
        this.gracefulShutdown = null;
        OooOoOOo oooOoOOo = this.createHttpHandler();
        this.builder.oO(oooOoOOo);
        return this.builder.oO();
    }

    protected OooOoOOo createHttpHandler() {
        OooOoOOo oooOoOOo = null;
        for (HttpHandlerFactory httpHandlerFactory : this.httpHandlerFactories) {
            oooOoOOo = httpHandlerFactory.getHandler(oooOoOOo);
            if (oooOoOOo instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)oooOoOOo);
                this.closeables.add(closeable);
            }
            if (!(oooOoOOo instanceof OoOo)) continue;
            OoOo ooOo = (OoOo)oooOoOOo;
            Assert.isNull((Object)this.gracefulShutdown, (String)"Only a single GracefulShutdownHandler can be defined");
            this.gracefulShutdown = ooOo;
        }
        return oooOoOOo;
    }

    private String getPortsDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        List<Port> list = this.getActualPorts();
        stringBuilder.append("port");
        if (list.size() != 1) {
            stringBuilder.append("s");
        }
        stringBuilder.append(" ");
        if (!list.isEmpty()) {
            stringBuilder.append(StringUtils.collectionToDelimitedString(list, (String)", "));
        } else {
            stringBuilder.append("unknown");
        }
        return stringBuilder.toString();
    }

    private List<Port> getActualPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                arrayList.add(new Port(-1, "unknown"));
            } else {
                for (oOOoOoOoOo oOOoOoOoOo2 : this.extractChannels()) {
                    arrayList.add(this.getPortFromChannel(oOOoOoOoOo2));
                }
            }
        }
        catch (Exception exception) {}
        return arrayList;
    }

    private List<oOOoOoOoOo> extractChannels() {
        Field field = ReflectionUtils.findField(Undertow.class, (String)"channels");
        ReflectionUtils.makeAccessible((Field)field);
        return (List)ReflectionUtils.getField((Field)field, (Object)this.undertow);
    }

    private Port getPortFromChannel(oOOoOoOoOo object) {
        SocketAddress socketAddress = object.OoOoOoOo();
        if (socketAddress instanceof InetSocketAddress) {
            socketAddress = (InetSocketAddress)socketAddress;
            object = (object = ReflectionUtils.findField(object.getClass(), (String)"ssl")) != null ? "https" : "http";
            return new Port(((InetSocketAddress)socketAddress).getPort(), (String)object);
        }
        return null;
    }

    private List<Port> getConfiguredPorts() {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        for (Object object : this.extractListeners()) {
            try {
                if (((Port)(object = this.getPortFromListener(object))).getNumber() == 0) continue;
                arrayList.add((Port)object);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private List<Object> extractListeners() {
        Field field = ReflectionUtils.findField(Undertow.class, (String)"listeners");
        ReflectionUtils.makeAccessible((Field)field);
        return (List)ReflectionUtils.getField((Field)field, (Object)this.undertow);
    }

    private Port getPortFromListener(Object object) {
        Object object2 = ReflectionUtils.findField(object.getClass(), (String)"type");
        ReflectionUtils.makeAccessible((Field)object2);
        object2 = ReflectionUtils.getField((Field)object2, (Object)object).toString();
        Field field = ReflectionUtils.findField(object.getClass(), (String)"port");
        ReflectionUtils.makeAccessible((Field)field);
        int n = (Integer)ReflectionUtils.getField((Field)field, (Object)object);
        return new Port(n, (String)object2);
    }

    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            if (this.gracefulShutdown != null) {
                this.notifyGracefulCallback(false);
            }
            try {
                this.undertow.stop();
                for (Closeable closeable : this.closeables) {
                    closeable.close();
                }
            }
            catch (Exception exception) {
                throw new WebServerException("Unable to stop Undertow", (Throwable)exception);
            }
            return;
        }
    }

    public int getPort() {
        List<Port> list = this.getActualPorts();
        if (list.isEmpty()) {
            return -1;
        }
        return list.get(0).getNumber();
    }

    public void shutDownGracefully(GracefulShutdownCallback gracefulShutdownCallback) {
        if (this.gracefulShutdown == null) {
            gracefulShutdownCallback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        logger.info((Object)"Commencing graceful shutdown. Waiting for active requests to complete");
        this.gracefulShutdownCallback.set(gracefulShutdownCallback);
        this.gracefulShutdown.oO();
        this.gracefulShutdown.oO(this::notifyGracefulCallback);
    }

    private void notifyGracefulCallback(boolean bl) {
        GracefulShutdownCallback gracefulShutdownCallback = this.gracefulShutdownCallback.getAndSet(null);
        if (gracefulShutdownCallback != null) {
            if (bl) {
                logger.info((Object)"Graceful shutdown complete");
                gracefulShutdownCallback.shutdownComplete(GracefulShutdownResult.IDLE);
                return;
            }
            logger.info((Object)"Graceful shutdown aborted with one or more requests still active");
            gracefulShutdownCallback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        }
    }

    protected String getStartLogMessage() {
        return "Undertow started on " + this.getPortsDescription();
    }

    public OoOooOoOoOOo bind(String string, int n) {
        return this.undertow.bind(string, n);
    }

    private static final class CloseableHttpHandlerFactory
    implements HttpHandlerFactory {
        private final Closeable closeable;

        private CloseableHttpHandlerFactory(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public final OooOoOOo getHandler(final OooOoOOo oooOoOOo) {
            if (this.closeable == null) {
                return oooOoOOo;
            }
            return new CloseableHttpHandler(){

                @Override
                public void handleRequest(oOOooOOo oOOooOOo2) {
                    oooOoOOo.handleRequest(oOOooOOo2);
                }

                @Override
                public void close() {
                    closeable.close();
                }
            };
        }
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int n, String string) {
            this.number = n;
            this.protocol = string;
        }

        final int getNumber() {
            return this.number;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (Port)object;
            return this.number == ((Port)object).number;
        }

        public final int hashCode() {
            return this.number;
        }

        public final String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }

    static class UndertowWebServerRuntimeHints
    implements RuntimeHintsRegistrar {
        UndertowWebServerRuntimeHints() {
        }

        public void registerHints(RuntimeHints runtimeHints, ClassLoader classLoader) {
            runtimeHints.reflection().registerTypeIfPresent(classLoader, "io.undertow.Undertow", builder -> builder.withField("listeners").withField("channels"));
            runtimeHints.reflection().registerTypeIfPresent(classLoader, "io.undertow.Undertow$ListenerConfig", builder -> builder.withField("type").withField("port"));
            runtimeHints.reflection().registerTypeIfPresent(classLoader, "io.undertow.protocols.ssl.UndertowAcceptingSslChannel", builder -> builder.withField("ssl"));
        }
    }

    private static interface CloseableHttpHandler
    extends OooOoOOo,
    Closeable {
    }
}

