/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.gateway.springboot.web.embed;

import io.undertow.Undertow;
import io.undertow.gateway.springboot.web.embed.UndertowBuilderCustomizer;
import java.net.InetAddress;
import javax.net.ssl.SSLContext;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.web.server.Ssl;

class SslBuilderCustomizer
implements UndertowBuilderCustomizer {
    private final int port;
    private final InetAddress address;
    private final Ssl.ClientAuth clientAuth;
    private final SslBundle sslBundle;

    SslBuilderCustomizer(int n, InetAddress inetAddress, Ssl.ClientAuth clientAuth, SslBundle sslBundle) {
        this.port = n;
        this.address = inetAddress;
        this.clientAuth = clientAuth;
        this.sslBundle = sslBundle;
    }

    @Override
    public void customize(Undertow.oO oO2) {
        this.sslBundle.getOptions();
        SSLContext sSLContext = this.sslBundle.createSslContext();
        oO2.oO(this.port, this.getListenAddress(), sSLContext);
    }

    private String getListenAddress() {
        if (this.address == null) {
            return "0.0.0.0";
        }
        return this.address.getHostAddress();
    }
}

