/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.gateway.springboot.web.embed;

import cn.iinti.majora3.0O.oOOoOooOoOoOOo.OooOoOOo;
import cn.iinti.majora3.0O.oOoOoOOooOoOOo.Oo;
import cn.iinti.majora3.0O.oOoOoOOooOoOOo.oO;
import cn.iinti.majora3.0O.oOoOoOOooOoOOo.oOOo;
import io.undertow.Undertow;
import io.undertow.gateway.springboot.web.embed.HttpHandlerFactory;
import io.undertow.gateway.springboot.web.embed.NamedThreadFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

class AccessLogHttpHandlerFactory
implements HttpHandlerFactory {
    private final File directory;
    private final String pattern;
    private final String prefix;
    private final String suffix;
    private final boolean rotate;

    AccessLogHttpHandlerFactory(File file, String string, String string2, String string3, boolean bl) {
        this.directory = file;
        this.pattern = string;
        this.prefix = string2;
        this.suffix = string3;
        this.rotate = bl;
    }

    @Override
    public OooOoOOo getHandler(OooOoOOo oooOoOOo) {
        try {
            this.createAccessLogDirectoryIfNecessary();
            ExecutorService executorService = this.createWorker();
            String string = this.prefix != null ? this.prefix : "access_log.";
            String string2 = this.pattern != null ? this.pattern : "common";
            return new ClosableAccessLogHandler(oooOoOOo, executorService, new oOOo(executorService, this.directory, string, this.suffix, this.rotate), string2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to create AccessLogHandler", iOException);
        }
    }

    private void createAccessLogDirectoryIfNecessary() {
        Assert.state((this.directory != null ? 1 : 0) != 0, (String)"Access log directory is not set");
        if (!this.directory.isDirectory() && !this.directory.mkdirs()) {
            throw new IllegalStateException("Failed to create access log directory '" + String.valueOf(this.directory) + "'");
        }
    }

    private ExecutorService createWorker() {
        return Executors.newFixedThreadPool(1, new NamedThreadFactory("undertow-access-log", true));
    }

    private static class ClosableAccessLogHandler
    extends oO
    implements Closeable {
        private final oOOo accessLogReceiver;
        private final ExecutorService worker;

        ClosableAccessLogHandler(OooOoOOo oooOoOOo, ExecutorService executorService, oOOo oOOo2, String string) {
            super(oooOoOOo, (Oo)oOOo2, string, Undertow.class.getClassLoader());
            this.worker = executorService;
            this.accessLogReceiver = oOOo2;
        }

        @Override
        public void close() {
            try {
                this.accessLogReceiver.close();
                this.worker.shutdown();
                this.worker.awaitTermination(30L, TimeUnit.SECONDS);
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

