/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.spring;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisPlusVersion;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.MybatisXMLConfigBuilder;
import com.baomidou.mybatisplus.core.MybatisXMLMapperBuilder;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MybatisSqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisSqlSessionFactoryBean.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();
    private Resource configLocation;
    private MybatisConfiguration configuration;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new MybatisSqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private boolean failFast;
    private Interceptor[] plugins;
    private TypeHandler<?>[] typeHandlers;
    private String typeHandlersPackage;
    private Class<? extends TypeHandler> defaultEnumTypeHandler;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private LanguageDriver[] scriptingLanguageDrivers;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private DatabaseIdProvider databaseIdProvider;
    private Class<? extends VFS> vfs;
    private Cache cache;
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;
    @Deprecated
    private String typeEnumsPackage;
    private GlobalConfig globalConfig;

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        return this.databaseIdProvider;
    }

    public void setDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        this.databaseIdProvider = databaseIdProvider;
    }

    public Class<? extends VFS> getVfs() {
        return this.vfs;
    }

    public void setVfs(Class<? extends VFS> clazz) {
        this.vfs = clazz;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setPlugins(Interceptor ... interceptorArray) {
        this.plugins = interceptorArray;
    }

    public void setTypeAliasesPackage(String string) {
        this.typeAliasesPackage = string;
    }

    public void setTypeAliasesSuperType(Class<?> clazz) {
        this.typeAliasesSuperType = clazz;
    }

    public void setTypeHandlersPackage(String string) {
        this.typeHandlersPackage = string;
    }

    public void setTypeHandlers(TypeHandler<?> ... typeHandlerArray) {
        this.typeHandlers = typeHandlerArray;
    }

    public void setDefaultEnumTypeHandler(Class<? extends TypeHandler> clazz) {
        this.defaultEnumTypeHandler = clazz;
    }

    public void setTypeAliases(Class<?> ... classArray) {
        this.typeAliases = classArray;
    }

    public void setFailFast(boolean bl) {
        this.failFast = bl;
    }

    public void setConfigLocation(Resource resource) {
        this.configLocation = resource;
    }

    public void setConfiguration(MybatisConfiguration mybatisConfiguration) {
        this.configuration = mybatisConfiguration;
    }

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setMapperLocations(Resource ... resourceArray) {
        this.mapperLocations = resourceArray;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configurationProperties = properties;
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            this.dataSource = ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource();
            return;
        }
        this.dataSource = dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String string) {
        this.environment = string;
    }

    public void setScriptingLanguageDrivers(LanguageDriver ... languageDriverArray) {
        this.scriptingLanguageDrivers = languageDriverArray;
    }

    public void setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> clazz) {
        this.defaultScriptingLanguageDriver = clazz;
    }

    public void addMapperLocations(Resource ... resourceArray) {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
        mybatisSqlSessionFactoryBean.setMapperLocations(mybatisSqlSessionFactoryBean.appendArrays(this.mapperLocations, resourceArray, Resource[]::new));
    }

    public void addTypeHandlers(TypeHandler<?> ... typeHandlerArray) {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
        mybatisSqlSessionFactoryBean.setTypeHandlers(mybatisSqlSessionFactoryBean.appendArrays(this.typeHandlers, typeHandlerArray, TypeHandler[]::new));
    }

    public void addScriptingLanguageDrivers(LanguageDriver ... languageDriverArray) {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
        mybatisSqlSessionFactoryBean.setScriptingLanguageDrivers(mybatisSqlSessionFactoryBean.appendArrays(this.scriptingLanguageDrivers, languageDriverArray, LanguageDriver[]::new));
    }

    public void addPlugins(Interceptor ... interceptorArray) {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
        mybatisSqlSessionFactoryBean.setPlugins(mybatisSqlSessionFactoryBean.appendArrays(this.plugins, interceptorArray, Interceptor[]::new));
    }

    public void addTypeAliases(Class<?> ... classArray) {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
        mybatisSqlSessionFactoryBean.setTypeAliases(mybatisSqlSessionFactoryBean.appendArrays(this.typeAliases, classArray, Class[]::new));
    }

    private <T> T[] appendArrays(T[] object, T[] TArray, IntFunction<T[]> intFunction) {
        if (object == null) {
            return TArray;
        }
        if (TArray == null) {
            return object;
        }
        object = new ArrayList<T>(Arrays.asList(object));
        object.addAll(Arrays.asList(TArray));
        return object.toArray(intFunction.apply(0));
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.state((this.configuration == null && this.configLocation == null || this.configuration == null || this.configLocation == null ? 1 : 0) != 0, (String)"Property 'configuration' and 'configLocation' can not specified with together");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    protected SqlSessionFactory buildSqlSessionFactory() {
        MybatisConfiguration mybatisConfiguration;
        SqlSessionFactory sqlSessionFactory = null;
        if (this.configuration != null) {
            mybatisConfiguration = this.configuration;
            if (mybatisConfiguration.getVariables() == null) {
                mybatisConfiguration.setVariables(this.configurationProperties);
            } else if (this.configurationProperties != null) {
                mybatisConfiguration.getVariables().putAll((Map<?, ?>)this.configurationProperties);
            }
        } else if (this.configLocation != null) {
            sqlSessionFactory = new MybatisXMLConfigBuilder(this.configLocation.getInputStream(), null, this.configurationProperties);
            mybatisConfiguration = sqlSessionFactory.getConfiguration();
        } else {
            LOGGER.debug(() -> "Property 'configuration' or 'configLocation' not specified, using default MyBatis Configuration");
            mybatisConfiguration = new MybatisConfiguration();
            Optional.ofNullable(this.configurationProperties).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).setVariables(arg_0));
        }
        this.globalConfig = Optional.ofNullable(this.globalConfig).orElseGet(GlobalConfigUtils::defaults);
        this.globalConfig.setDbConfig(Optional.ofNullable(this.globalConfig.getDbConfig()).orElseGet(GlobalConfig.DbConfig::new));
        GlobalConfigUtils.setGlobalConfig((Configuration)mybatisConfiguration, (GlobalConfig)this.globalConfig);
        Optional.ofNullable(this.objectFactory).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).setObjectFactory(arg_0));
        Optional.ofNullable(this.objectWrapperFactory).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).setObjectWrapperFactory(arg_0));
        Optional.ofNullable(this.vfs).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).setVfsImpl(arg_0));
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
            mybatisSqlSessionFactoryBean.scanClasses(mybatisSqlSessionFactoryBean.typeAliasesPackage, this.typeAliasesSuperType).stream().filter(clazz -> !clazz.isAnonymousClass()).filter(clazz -> !clazz.isInterface()).filter(clazz -> !clazz.isMemberClass()).forEach(arg_0 -> ((TypeAliasRegistry)mybatisConfiguration.getTypeAliasRegistry()).registerAlias(arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            Stream.of(this.typeAliases).forEach(arg_0 -> MybatisSqlSessionFactoryBean.lambda$buildSqlSessionFactory$10((Configuration)mybatisConfiguration, arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            Stream.of(this.plugins).forEach(arg_0 -> MybatisSqlSessionFactoryBean.lambda$buildSqlSessionFactory$12((Configuration)mybatisConfiguration, arg_0));
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = this;
            mybatisSqlSessionFactoryBean.scanClasses(mybatisSqlSessionFactoryBean.typeHandlersPackage, TypeHandler.class).stream().filter(clazz -> !clazz.isAnonymousClass()).filter(clazz -> !clazz.isInterface()).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).forEach(arg_0 -> ((TypeHandlerRegistry)mybatisConfiguration.getTypeHandlerRegistry()).register(arg_0));
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            Stream.of(this.typeHandlers).forEach(arg_0 -> MybatisSqlSessionFactoryBean.lambda$buildSqlSessionFactory$17((Configuration)mybatisConfiguration, arg_0));
        }
        mybatisConfiguration.setDefaultEnumTypeHandler(this.defaultEnumTypeHandler);
        if (!ObjectUtils.isEmpty((Object[])this.scriptingLanguageDrivers)) {
            Stream.of(this.scriptingLanguageDrivers).forEach(arg_0 -> MybatisSqlSessionFactoryBean.lambda$buildSqlSessionFactory$19((Configuration)mybatisConfiguration, arg_0));
        }
        Optional.ofNullable(this.defaultScriptingLanguageDriver).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).setDefaultScriptingLanguage(arg_0));
        if (this.databaseIdProvider != null) {
            try {
                mybatisConfiguration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            catch (SQLException sQLException) {
                throw new IOException("Failed getting a databaseId", sQLException);
            }
        }
        Optional.ofNullable(this.cache).ifPresent(arg_0 -> ((Configuration)mybatisConfiguration).addCache(arg_0));
        if (sqlSessionFactory != null) {
            try {
                sqlSessionFactory.parse();
                LOGGER.debug(() -> "Parsed configuration file: '" + this.configLocation + "'");
            }
            catch (Exception exception) {
                throw new IOException("Failed to parse config resource: " + this.configLocation, exception);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        mybatisConfiguration.setEnvironment(new Environment(this.environment, (TransactionFactory)(this.transactionFactory == null ? new SpringManagedTransactionFactory() : this.transactionFactory), this.dataSource));
        if (this.mapperLocations != null) {
            if (this.mapperLocations.length == 0) {
                LOGGER.warn(() -> "Property 'mapperLocations' was specified but matching resources are not found.");
            } else {
                for (SqlSessionFactory sqlSessionFactory2 : this.mapperLocations) {
                    if (sqlSessionFactory2 == null) continue;
                    try {
                        MybatisXMLMapperBuilder mybatisXMLMapperBuilder = new MybatisXMLMapperBuilder(sqlSessionFactory2.getInputStream(), (Configuration)mybatisConfiguration, sqlSessionFactory2.toString(), mybatisConfiguration.getSqlFragments());
                        mybatisXMLMapperBuilder.parse();
                    }
                    catch (Exception exception) {
                        throw new IOException("Failed to parse mapping resource: '" + sqlSessionFactory2 + "'", exception);
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    LOGGER.debug(() -> MybatisSqlSessionFactoryBean.lambda$buildSqlSessionFactory$22((Resource)sqlSessionFactory2));
                }
            }
        } else {
            LOGGER.debug(() -> "Property 'mapperLocations' was not specified.");
        }
        sqlSessionFactory = this.sqlSessionFactoryBuilder.build((Configuration)mybatisConfiguration);
        if (this.globalConfig.isBanner()) {
            System.out.println(" _ _   |_  _ _|_. ___ _ |    _ ");
            System.out.println("| | |\\/|_)(_| | |_\\  |_)||_|_\\ ");
            System.out.println("     /               |         ");
            System.out.println("                        " + MybatisPlusVersion.getVersion() + " ");
        }
        return sqlSessionFactory;
    }

    public SqlSessionFactory getObject() {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        if (this.sqlSessionFactory == null) {
            return SqlSessionFactory.class;
        }
        return this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (this.failFast) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }

    private Set<Class<?>> scanClasses(String stringArray, Class<?> clazz) {
        HashSet hashSet = new HashSet();
        String[] stringArray2 = StringUtils.tokenizeToStringArray((String)stringArray, (String)",; \t\n");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            Resource[] resourceArray = stringArray[i];
            Resource[] resourceArray2 = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)resourceArray) + "/**/*.class");
            resourceArray = resourceArray2;
            resourceArray = resourceArray2;
            int n2 = resourceArray2.length;
            for (int j = 0; j < n2; ++j) {
                Resource resource = resourceArray[j];
                try {
                    Object object = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    object = Resources.classForName((String)object.getClassName());
                    if (clazz != null && !clazz.isAssignableFrom((Class<?>)object)) continue;
                    hashSet.add((Class<?>)object);
                    continue;
                }
                catch (Throwable throwable) {
                    LOGGER.warn(() -> "Cannot load the '" + resource + "'. Cause by " + throwable.toString());
                }
            }
        }
        return hashSet;
    }

    @Deprecated
    public void setTypeEnumsPackage(String string) {
        this.typeEnumsPackage = string;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    private static /* synthetic */ String lambda$buildSqlSessionFactory$22(Resource resource) {
        return "Parsed mapper file: '" + resource + "'";
    }

    private static /* synthetic */ void lambda$buildSqlSessionFactory$19(Configuration configuration, LanguageDriver languageDriver) {
        configuration.getLanguageRegistry().register(languageDriver);
        LOGGER.debug(() -> "Registered scripting language driver: '" + languageDriver + "'");
    }

    private static /* synthetic */ void lambda$buildSqlSessionFactory$17(Configuration configuration, TypeHandler typeHandler) {
        configuration.getTypeHandlerRegistry().register(typeHandler);
        LOGGER.debug(() -> "Registered type handler: '" + typeHandler + "'");
    }

    private static /* synthetic */ void lambda$buildSqlSessionFactory$12(Configuration configuration, Interceptor interceptor) {
        configuration.addInterceptor(interceptor);
        LOGGER.debug(() -> "Registered plugin: '" + interceptor + "'");
    }

    private static /* synthetic */ void lambda$buildSqlSessionFactory$10(Configuration configuration, Class clazz) {
        configuration.getTypeAliasRegistry().registerAlias(clazz);
        LOGGER.debug(() -> "Registered type alias: '" + clazz + "'");
    }
}

