/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import cn.iinti.majora3.0O.OooOoOOooOOo.Oo;
import cn.iinti.majora3.0O.OooOoOOooOOo.oO;
import cn.iinti.majora3.0O.oOoOoOOooOOo.oOOo;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ParameterUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class PaginationInnerInterceptor
implements InnerInterceptor {
    protected static final List<SelectItem<?>> COUNT_SELECT_ITEM = Collections.singletonList(new SelectItem((Expression)new Column().withColumnName("COUNT(*)")).withAlias(new Alias("total")));
    protected static final Map<String, MappedStatement> countMsCache = new ConcurrentHashMap<String, MappedStatement>();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected boolean overflow;
    protected Long maxLimit;
    private DbType dbType;
    private oOOo dialect;
    protected boolean optimizeJoin = true;

    public PaginationInnerInterceptor(DbType dbType) {
        this.dbType = dbType;
    }

    public PaginationInnerInterceptor(oOOo oOOo2) {
        this.dialect = oOOo2;
    }

    @Override
    public boolean willDoQuery(Executor object, MappedStatement mappedStatement, Object object2, RowBounds rowBounds, ResultHandler resultHandler, BoundSql object3) {
        String string;
        IPage iPage = ParameterUtils.findPage((Object)object2).orElse(null);
        if (iPage == null || iPage.getSize() < 0L || !iPage.searchCount() || resultHandler != Executor.NO_RESULT_HANDLER) {
            return true;
        }
        MappedStatement mappedStatement2 = this.buildCountMappedStatement(mappedStatement, iPage.countId());
        if (mappedStatement2 != null) {
            mappedStatement = mappedStatement2.getBoundSql(object2);
        } else {
            mappedStatement2 = this.buildAutoCountMappedStatement(mappedStatement);
            string = this.autoCountSql(iPage, object3.getSql());
            object3 = PluginUtils.mpBoundSql((BoundSql)object3);
            mappedStatement = new BoundSql(mappedStatement2.getConfiguration(), string, object3.parameterMappings(), object2);
            PluginUtils.setAdditionalParameter((BoundSql)mappedStatement, (Map)object3.additionalParameters());
        }
        string = object.createCacheKey(mappedStatement2, object2, rowBounds, (BoundSql)mappedStatement);
        object3 = object.query(mappedStatement2, object2, rowBounds, resultHandler, (CacheKey)string, (BoundSql)mappedStatement);
        long l = 0L;
        if (CollectionUtils.isNotEmpty((Collection)object3) && (object = object3.get(0)) != null) {
            l = Long.parseLong(object.toString());
        }
        iPage.setTotal(l);
        return this.continuePage(iPage);
    }

    @Override
    public void beforeQuery(Executor object, MappedStatement mappedStatement, Object object2, RowBounds rowBounds, ResultHandler object3, BoundSql boundSql) {
        if ((object2 = (IPage)ParameterUtils.findPage((Object)object2).orElse(null)) == null) {
            return;
        }
        boolean bl = false;
        object3 = boundSql.getSql();
        Object object4 = object2.orders();
        if (CollectionUtils.isNotEmpty((Collection)object4)) {
            bl = true;
            object3 = this.concatOrderBy((String)object3, (List<OrderItem>)object4);
        }
        Object object5 = object4 = object2.maxLimit() != null ? object2.maxLimit() : this.maxLimit;
        if (object2.getSize() < 0L && object4 == null) {
            if (bl) {
                PluginUtils.mpBoundSql((BoundSql)boundSql).sql((String)object3);
            }
            return;
        }
        this.handlerLimit((IPage<?>)object2, (Long)object4);
        object = this.findIDialect((Executor)object);
        mappedStatement = mappedStatement.getConfiguration();
        object = object.oO((String)object3, object2.offset(), object2.getSize());
        object2 = PluginUtils.mpBoundSql((BoundSql)boundSql);
        List list = object2.parameterMappings();
        object3 = object2.additionalParameters();
        ((cn.iinti.majora3.0O.OoOoOooOoOOo.Oo)object).oO(list, (Configuration)mappedStatement, (Map<String, Object>)object3);
        object2.sql(((cn.iinti.majora3.0O.OoOoOooOoOOo.Oo)object).Oo());
        object2.parameterMappings(list);
    }

    protected oOOo findIDialect(Executor executor) {
        if (this.dialect != null) {
            return this.dialect;
        }
        if (this.dbType != null) {
            this.dialect = cn.iinti.majora3.0O.OoOoOooOoOOo.oO.oO(this.dbType);
            return this.dialect;
        }
        return cn.iinti.majora3.0O.OoOoOooOoOOo.oO.oO(oO.oO(executor));
    }

    protected MappedStatement buildCountMappedStatement(MappedStatement mappedStatement, String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String string2 = mappedStatement.getId();
            if (!string.contains(".")) {
                string = string2.substring(0, string2.lastIndexOf(".") + 1) + string;
            }
            mappedStatement = mappedStatement.getConfiguration();
            try {
                return (MappedStatement)CollectionUtils.computeIfAbsent(countMsCache, (Object)string, arg_0 -> PaginationInnerInterceptor.lambda$buildCountMappedStatement$0((Configuration)mappedStatement, arg_0));
            }
            catch (Exception exception) {
                this.logger.warn(String.format("can not find this countId: [\"%s\"]", string));
            }
        }
        return null;
    }

    protected MappedStatement buildAutoCountMappedStatement(MappedStatement mappedStatement) {
        String string2 = mappedStatement.getId() + "_mpCount";
        Configuration configuration = mappedStatement.getConfiguration();
        return (MappedStatement)CollectionUtils.computeIfAbsent(countMsCache, (Object)string2, string -> {
            string = new MappedStatement.Builder(configuration, string, mappedStatement.getSqlSource(), mappedStatement.getSqlCommandType());
            string.resource(mappedStatement.getResource());
            string.fetchSize(mappedStatement.getFetchSize());
            string.statementType(mappedStatement.getStatementType());
            string.timeout(mappedStatement.getTimeout());
            string.parameterMap(mappedStatement.getParameterMap());
            string.resultMaps(Collections.singletonList(new ResultMap.Builder(configuration, "mybatis-plus", Long.class, Collections.emptyList()).build()));
            string.resultSetType(mappedStatement.getResultSetType());
            string.cache(mappedStatement.getCache());
            string.flushCacheRequired(mappedStatement.isFlushCacheRequired());
            string.useCache(mappedStatement.isUseCache());
            return string.build();
        });
    }

    protected String autoCountSql(IPage<?> join2, String string) {
        if (!join2.optimizeCountSql()) {
            return this.lowLevelCountSql(string);
        }
        try {
            Object object;
            Object object2;
            Select select = (Select)cn.iinti.majora3.0O.oOoOOooOoOOo.Oo.oO(string);
            if (select instanceof SetOperationList) {
                return this.lowLevelCountSql(string);
            }
            PlainSelect plainSelect = (PlainSelect)select;
            Object object3 = plainSelect.getDistinct();
            Object object4 = plainSelect.getGroupBy();
            if (object3 != null || object4 != null) {
                return this.lowLevelCountSql(select.toString());
            }
            object3 = plainSelect.getOrderByElements();
            if (CollectionUtils.isNotEmpty((Collection)object3)) {
                boolean bl = true;
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    object2 = (OrderByElement)object3.next();
                    object = object2.getExpression();
                    if (object instanceof Column || !object.toString().contains("?")) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    plainSelect.setOrderByElements(null);
                }
            }
            object4 = plainSelect.getSelectItems().iterator();
            while (object4.hasNext()) {
                object3 = (SelectItem)object4.next();
                if (!object3.toString().contains("?")) continue;
                return this.lowLevelCountSql(select.toString());
            }
            if (this.optimizeJoin && join2.optimizeJoinOfCountSql() && CollectionUtils.isNotEmpty((Collection)(object4 = plainSelect.getJoins()))) {
                boolean bl = true;
                object2 = Optional.ofNullable(plainSelect.getWhere()).map(Expression::toString).orElse("");
                object2 = ((String)object2).toLowerCase();
                object = object4.iterator();
                block5: while (object.hasNext()) {
                    join2 = (Join)object.next();
                    if (!join2.isLeft()) {
                        bl = false;
                        break;
                    }
                    object4 = join2.getRightItem();
                    String string2 = "";
                    if (object4 instanceof Table) {
                        object4 = (Table)object4;
                        string2 = Optional.ofNullable(object4.getAlias()).map(Alias::getName).orElse(object4.getName()) + ".";
                    } else if (object4 instanceof ParenthesedSelect) {
                        if ((object4 = (ParenthesedSelect)object4).toString().contains("?")) {
                            bl = false;
                            break;
                        }
                        string2 = object4.getAlias().getName() + ".";
                    }
                    string2 = string2.toLowerCase();
                    if (((String)object2).contains(string2)) {
                        bl = false;
                        break;
                    }
                    for (Join join2 : join2.getOnExpressions()) {
                        if (!join2.toString().contains("?")) continue;
                        bl = false;
                        continue block5;
                    }
                }
                if (bl) {
                    plainSelect.setJoins(null);
                }
            }
            plainSelect.setSelectItems(COUNT_SELECT_ITEM);
            return select.toString();
        }
        catch (JSQLParserException jSQLParserException) {
            this.logger.warn("optimize this sql to a count sql has exception, sql:\"" + string + "\", exception:\n" + jSQLParserException.getCause());
        }
        catch (Exception exception) {
            this.logger.warn("optimize this sql to a count sql has error, sql:\"" + string + "\", exception:\n" + exception);
        }
        return this.lowLevelCountSql(string);
    }

    protected String lowLevelCountSql(String string) {
        return String.format("SELECT COUNT(*) FROM (%s) TOTAL", string);
    }

    public String concatOrderBy(String string, List<OrderItem> list) {
        Select select;
        block5: {
            try {
                select = (Select)cn.iinti.majora3.0O.oOoOOooOoOOo.Oo.oO(string);
                if (select instanceof PlainSelect) {
                    select = (PlainSelect)select;
                    List list2 = select.getOrderByElements();
                    list = this.addOrderByElements(list, list2);
                    select.setOrderByElements(list);
                    return select.toString();
                }
                if (!(select instanceof SetOperationList)) break block5;
                select = (SetOperationList)select;
                List list3 = select.getOrderByElements();
                list = this.addOrderByElements(list, list3);
                select.setOrderByElements(list);
                return select.toString();
            }
            catch (JSQLParserException jSQLParserException) {
                this.logger.warn("failed to concat orderBy from IPage, exception:\n" + jSQLParserException.getCause());
            }
            catch (Exception exception) {
                this.logger.warn("failed to concat orderBy from IPage, exception:\n" + exception);
            }
        }
        if (select instanceof WithItem) {
            return string;
        }
        return string;
    }

    protected List<OrderByElement> addOrderByElements(List<OrderItem> list, List<OrderByElement> list2) {
        list = list.stream().filter(orderItem -> StringUtils.isNotBlank((CharSequence)orderItem.getColumn())).map(orderItem -> {
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.setExpression((Expression)new Column(orderItem.getColumn()));
            orderByElement.setAsc(orderItem.isAsc());
            orderByElement.setAscDescPresent(true);
            return orderByElement;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list2)) {
            return list;
        }
        list.addAll(list2);
        return list;
    }

    protected boolean continuePage(IPage<?> iPage) {
        if (iPage.getTotal() <= 0L) {
            return false;
        }
        if (iPage.getCurrent() > iPage.getPages()) {
            if (this.overflow) {
                this.handlerOverflow(iPage);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void handlerLimit(IPage<?> iPage, Long l) {
        long l2 = iPage.getSize();
        if (l != null && l > 0L && (l2 > l || l2 < 0L)) {
            iPage.setSize(l.longValue());
        }
    }

    protected void handlerOverflow(IPage<?> iPage) {
        iPage.setCurrent(1L);
    }

    @Override
    public void setProperties(Properties properties) {
        Oo.oO(properties).oO("overflow", Boolean::parseBoolean, this::setOverflow).oO("dbType", DbType::getDbType, this::setDbType).oO("dialect", ClassUtils::newInstance, this::setDialect).oO("maxLimit", Long::parseLong, this::setMaxLimit).oO("optimizeJoin", Boolean::parseBoolean, this::setOptimizeJoin);
    }

    public Log getLogger() {
        return this.logger;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public Long getMaxLimit() {
        return this.maxLimit;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public oOOo getDialect() {
        return this.dialect;
    }

    public boolean isOptimizeJoin() {
        return this.optimizeJoin;
    }

    public void setOverflow(boolean bl) {
        this.overflow = bl;
    }

    public void setMaxLimit(Long l) {
        this.maxLimit = l;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void setDialect(oOOo oOOo2) {
        this.dialect = oOOo2;
    }

    public void setOptimizeJoin(boolean bl) {
        this.optimizeJoin = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PaginationInnerInterceptor)) {
            return false;
        }
        if (!((PaginationInnerInterceptor)(object = (PaginationInnerInterceptor)object)).canEqual(this)) {
            return false;
        }
        if (this.isOverflow() != ((PaginationInnerInterceptor)object).isOverflow()) {
            return false;
        }
        if (this.isOptimizeJoin() != ((PaginationInnerInterceptor)object).isOptimizeJoin()) {
            return false;
        }
        Object object2 = this.getMaxLimit();
        Long l = ((PaginationInnerInterceptor)object).getMaxLimit();
        if (object2 == null ? l != null : !object2.equals(l)) {
            return false;
        }
        object2 = this.getLogger();
        l = ((PaginationInnerInterceptor)object).getLogger();
        if (object2 == null ? l != null : !object2.equals(l)) {
            return false;
        }
        object2 = this.getDbType();
        l = ((PaginationInnerInterceptor)object).getDbType();
        if (object2 == null ? l != null : !object2.equals(l)) {
            return false;
        }
        object2 = this.getDialect();
        object = ((PaginationInnerInterceptor)object).getDialect();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PaginationInnerInterceptor;
    }

    public int hashCode() {
        int n = 59 + (this.isOverflow() ? 79 : 97);
        n = n * 59 + (this.isOptimizeJoin() ? 79 : 97);
        Object object = this.getMaxLimit();
        n = n * 59 + (object == null ? 43 : object.hashCode());
        object = this.getLogger();
        n = n * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDbType();
        n = n * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDialect();
        n = n * 59 + (object == null ? 43 : object.hashCode());
        return n;
    }

    public String toString() {
        return "PaginationInnerInterceptor(logger=" + this.getLogger() + ", overflow=" + this.isOverflow() + ", maxLimit=" + this.getMaxLimit() + ", dbType=" + this.getDbType() + ", dialect=" + this.getDialect() + ", optimizeJoin=" + this.isOptimizeJoin() + ")";
    }

    public PaginationInnerInterceptor() {
    }

    private static /* synthetic */ MappedStatement lambda$buildCountMappedStatement$0(Configuration configuration, String string) {
        return configuration.getMappedStatement(string, false);
    }
}

