/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class OptimisticLockerInnerInterceptor
implements InnerInterceptor {
    private RuntimeException exception;
    private static final Map<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final Pattern PARAM_PAIRS_RE = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");
    private static final String UPDATED_VERSION_VAL_KEY = "#updatedVersionVal#";
    private final boolean wrapperMode;

    public void setException(RuntimeException runtimeException) {
        this.exception = runtimeException;
    }

    public OptimisticLockerInnerInterceptor() {
        this(false);
    }

    public OptimisticLockerInnerInterceptor(boolean bl) {
        this.wrapperMode = bl;
    }

    @Override
    public void beforeUpdate(Executor object, MappedStatement mappedStatement, Object object2) {
        if (SqlCommandType.UPDATE != mappedStatement.getSqlCommandType()) {
            return;
        }
        if (object2 instanceof Map) {
            object = (Map)object2;
            this.doOptimisticLocker((Map<String, Object>)object, mappedStatement.getId());
        }
    }

    protected void doOptimisticLocker(Map<String, Object> map, String string) {
        Object object = map.getOrDefault("et", null);
        if (Objects.nonNull(object)) {
            Object object2 = this.getVersionFieldInfo(object.getClass());
            if (object2 == null) {
                return;
            }
            try {
                Field field = object2.getField();
                Object object3 = field.get(object);
                if (object3 == null) {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return;
                }
                String string2 = object2.getColumn();
                object2 = this.getUpdatedVersionVal(object2.getPropertyType(), object3);
                String string3 = string;
                string = string3.substring(string3.lastIndexOf(".") + 1);
                if ("update".equals(string)) {
                    string = map.getOrDefault("ew", null);
                    if (string == null) {
                        string = new UpdateWrapper();
                        string.eq((Object)string2, object3);
                        map.put("ew", string);
                    } else {
                        string.apply(string2 + " = {0}", new Object[]{object3});
                    }
                } else {
                    map.put("MP_OPTLOCK_VERSION_ORIGINAL", object3);
                }
                field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                throw ExceptionUtils.mpe((Throwable)illegalAccessException);
            }
        } else if (this.wrapperMode && map.entrySet().stream().anyMatch(entry -> Objects.equals(entry.getKey(), "ew"))) {
            this.setVersionByWrapper(map, string);
        }
    }

    protected TableFieldInfo getVersionFieldInfo(Class<?> tableInfo) {
        if ((tableInfo = TableInfoHelper.getTableInfo(tableInfo)) != null && tableInfo.isWithVersion()) {
            return tableInfo.getVersionFieldInfo();
        }
        return null;
    }

    private void setVersionByWrapper(Map<String, Object> object, String string) {
        if ((object = object.get("ew")) instanceof AbstractWrapper && object instanceof Update) {
            Object object2 = ENTITY_CLASS_CACHE.get(string);
            if (object2 == null) {
                try {
                    object2 = string.substring(0, string.lastIndexOf(46));
                    object2 = ReflectionKit.getSuperClassGenericType(Class.forName((String)object2), Mapper.class, (int)0);
                    ENTITY_CLASS_CACHE.put(string, (Class<?>)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object2 = classNotFoundException;
                    throw ExceptionUtils.mpe((Throwable)classNotFoundException);
                }
            }
            if ((object2 = this.getVersionFieldInfo((Class<?>)object2)) == null) {
                return;
            }
            string = object2.getColumn();
            if (!(object2 = new FieldEqFinder(string, (Wrapper)object)).isPresent()) {
                return;
            }
            Map map = ((AbstractWrapper)object).getParamNameValuePairs();
            object2 = map.get(((FieldEqFinder)object2).valueKey);
            if (object2 == null) {
                return;
            }
            Object object3 = this.getUpdatedVersionVal(object2.getClass(), object2);
            if (object2 == object3) {
                return;
            }
            map.put(UPDATED_VERSION_VAL_KEY, object3);
            ((Update)object).setSql(String.format("%s = #{%s.%s}", string, "ew.paramNameValuePairs", UPDATED_VERSION_VAL_KEY), new Object[0]);
        }
    }

    protected Object getUpdatedVersionVal(Class<?> clazz, Object object) {
        return VersionFactory.getUpdatedVersionVal(clazz, object);
    }

    private static class FieldEqFinder {
        private String valueKey;
        private State state;
        private final String fieldName;

        public FieldEqFinder(String string, Wrapper<?> wrapper) {
            this.fieldName = string;
            this.state = State.INIT;
            this.find(wrapper);
        }

        public boolean isPresent() {
            return this.state == State.VERSION_VALUE_PRESENT;
        }

        private boolean find(Wrapper<?> object) {
            object = object.getExpression().getNormal();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ISqlSegment iSqlSegment = (ISqlSegment)iterator.next();
                if (this.state == State.FIELD_FOUND && iSqlSegment == SqlKeyword.EQ) {
                    this.state = State.EQ_FOUND;
                    continue;
                }
                if (this.state == State.EQ_FOUND && ((Matcher)(object = PARAM_PAIRS_RE.matcher(iSqlSegment.getSqlSegment()))).matches()) {
                    this.valueKey = ((Matcher)object).group(1);
                    this.state = State.VERSION_VALUE_PRESENT;
                    return true;
                }
                if (iSqlSegment instanceof Wrapper) {
                    if (!this.find((Wrapper)iSqlSegment)) continue;
                    return true;
                }
                if (!iSqlSegment.getSqlSegment().equals(this.fieldName)) continue;
                this.state = State.FIELD_FOUND;
            }
            return false;
        }

        static enum State {
            INIT,
            FIELD_FOUND,
            EQ_FOUND,
            VERSION_VALUE_PRESENT;

        }
    }

    private static class VersionFactory {
        private static final Map<Class<?>, Function<Object, Object>> VERSION_FUNCTION_MAP = new HashMap();

        private VersionFactory() {
        }

        public static Object getUpdatedVersionVal(Class<?> object, Object object2) {
            if ((object = VERSION_FUNCTION_MAP.get(object)) == null) {
                return object2;
            }
            return object.apply(object2);
        }

        static {
            VERSION_FUNCTION_MAP.put(Long.TYPE, object -> (Long)object + 1L);
            VERSION_FUNCTION_MAP.put(Long.class, object -> (Long)object + 1L);
            VERSION_FUNCTION_MAP.put(Integer.TYPE, object -> (Integer)object + 1);
            VERSION_FUNCTION_MAP.put(Integer.class, object -> (Integer)object + 1);
            VERSION_FUNCTION_MAP.put(Date.class, object -> new Date());
            VERSION_FUNCTION_MAP.put(Timestamp.class, object -> new Timestamp(System.currentTimeMillis()));
            VERSION_FUNCTION_MAP.put(LocalDateTime.class, object -> LocalDateTime.now());
            VERSION_FUNCTION_MAP.put(Instant.class, object -> Instant.now());
        }
    }
}

