/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import cn.iinti.majora3.0O.oOoOOooOoOOo.Oo;
import com.baomidou.mybatisplus.annotation.IEnum;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecorderInnerInterceptor
implements InnerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String IGNORED_TABLE_COLUMN_PROPERTIES = "ignoredTableColumns";
    private final Map<String, Set<String>> ignoredTableColumns = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> ignoreAllColumns = new HashSet<String>();
    private int BATCH_UPDATE_LIMIT = 1000;
    private boolean batchUpdateLimitationOpened = false;
    private final Map<String, Integer> BATCH_UPDATE_LIMIT_MAP = new ConcurrentHashMap<String, Integer>();

    @Override
    public void beforePrepare(StatementHandler object, Connection connection, Integer n) {
        object = PluginUtils.mpStatementHandler((StatementHandler)object);
        n = object.mappedStatement();
        BoundSql boundSql = object.boundSql();
        SqlCommandType sqlCommandType = n.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.INSERT || sqlCommandType == SqlCommandType.UPDATE || sqlCommandType == SqlCommandType.DELETE) {
            long l;
            block8: {
                sqlCommandType = object.mPBoundSql();
                l = System.currentTimeMillis();
                try {
                    Statement statement = Oo.oO(sqlCommandType.sql());
                    if (statement instanceof Insert) {
                        object = this.processInsert((Insert)statement, object.boundSql());
                        break block8;
                    }
                    if (statement instanceof Update) {
                        object = this.processUpdate((Update)statement, (MappedStatement)n, boundSql, connection);
                        break block8;
                    }
                    if (statement instanceof Delete) {
                        object = this.processDelete((Delete)statement, (MappedStatement)n, boundSql, connection);
                        break block8;
                    }
                    this.logger.info("other operation sql={}", (Object)sqlCommandType.sql());
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)exception2);
                    }
                    this.logger.error("Unexpected error for mappedStatement={}, sql={}", new Object[]{n.getId(), sqlCommandType.sql(), exception2});
                    return;
                }
            }
            long l2 = System.currentTimeMillis() - l;
            if (object != null) {
                ((OperationResult)object).setCost(l2);
                this.dealOperationResult((OperationResult)object);
            }
        }
    }

    protected boolean allowProcess(String string) {
        return (string = string.trim().toUpperCase()).startsWith("INSERT") || string.startsWith("UPDATE") || string.startsWith("DELETE");
    }

    protected void dealOperationResult(OperationResult operationResult) {
        this.logger.info("{}", (Object)operationResult);
    }

    public OperationResult processInsert(Insert object, BoundSql boundSql) {
        OperationResult operationResult = new OperationResult();
        operationResult.setOperation("insert");
        operationResult.setTableName(object.getTable().getName());
        operationResult.setRecordStatus(true);
        object = this.getUpdatedColumnDatas(operationResult.getTableName(), boundSql, (Statement)object);
        operationResult.buildDataStr(this.compareAndGetUpdatedColumnDatas(operationResult.getTableName(), null, (Map<String, Object>)object));
        return operationResult;
    }

    public OperationResult processUpdate(Update object, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Expression expression = object.getWhere();
        PlainSelect plainSelect = new PlainSelect();
        Table table = object.getTable();
        Set<String> set = this.ignoredTableColumns.get(table.getName().toUpperCase());
        if (set != null && set.stream().anyMatch("*"::equals)) {
            set = new OperationResult();
            ((OperationResult)((Object)set)).setOperation("update");
            ((OperationResult)((Object)set)).setTableName(table.getName() + ":*");
            ((OperationResult)((Object)set)).setRecordStatus(false);
            return set;
        }
        plainSelect.setFromItem((FromItem)table);
        set = new ArrayList();
        for (UpdateSet object22 : object.getUpdateSets()) {
            set.addAll((Collection<String>)object22.getColumns());
        }
        Columns2SelectItemsResult columns2SelectItemsResult = this.buildColumns2SelectItems(table.getName(), (List<Column>)((Object)set));
        plainSelect.setSelectItems(columns2SelectItemsResult.getSelectItems());
        plainSelect.setWhere(expression);
        SelectItem selectItem = new SelectItem((Expression)plainSelect);
        expression = new BoundSql(mappedStatement.getConfiguration(), selectItem.toString(), this.prepareParameterMapping4Select(boundSql.getParameterMappings(), (Update)object), boundSql.getParameterObject());
        set = PluginUtils.mpBoundSql((BoundSql)boundSql);
        set = set.additionalParameters();
        if (set != null && !set.isEmpty()) {
            for (Map.Entry entry : set.entrySet()) {
                expression.setAdditionalParameter((String)entry.getKey(), entry.getValue());
            }
        }
        set = this.getUpdatedColumnDatas(table.getName(), boundSql, (Statement)object);
        OriginalDataObj originalDataObj = this.buildOriginalObjectData((Map<String, Object>)((Object)set), (Select)plainSelect, columns2SelectItemsResult.getPk(), mappedStatement, (BoundSql)expression, connection);
        object = new OperationResult();
        ((OperationResult)object).setOperation("update");
        ((OperationResult)object).setTableName(table.getName());
        ((OperationResult)object).setRecordStatus(true);
        ((OperationResult)object).buildDataStr(this.compareAndGetUpdatedColumnDatas(((OperationResult)object).getTableName(), originalDataObj, (Map<String, Object>)((Object)set)));
        return object;
    }

    private TableInfo getTableInfoByTableName(String string) {
        for (TableInfo tableInfo : TableInfoHelper.getTableInfos()) {
            if (!string.equalsIgnoreCase(tableInfo.getTableName())) continue;
            return tableInfo;
        }
        return null;
    }

    private List<ParameterMapping> prepareParameterMapping4Select(List<ParameterMapping> list, Update object) {
        Expression expression2 = new ArrayList();
        for (Object object2 : object.getUpdateSets()) {
            expression2.addAll(object2.getValues());
        }
        int n = 0;
        for (Expression expression2 : expression2) {
            if (!(expression2 instanceof JdbcParameter)) continue;
            ++n;
        }
        return list.subList(n, list.size());
    }

    protected Map<String, Object> getUpdatedColumnDatas(String string, BoundSql boundSql, Statement object) {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(boundSql.getParameterMappings().size());
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(boundSql.getParameterMappings().size());
        Object object3 = new ArrayList();
        if (object instanceof Update) {
            object = (Update)object;
            int n = 0;
            for (Object object4 : object.getUpdateSets()) {
                object3.addAll(object4.getColumns());
                ExpressionList expressionList = object4.getValues();
                for (int i = 0; i < expressionList.size(); ++i) {
                    object2 = (String[])expressionList.get(i);
                    if (!(object2 instanceof JdbcParameter)) {
                        hashMap.put(((Column)object4.getColumns().get(i)).getColumnName().toUpperCase(), object2.toString());
                    }
                    hashMap2.put(n++, ((Column)object4.getColumns().get(i)).getColumnName().toUpperCase());
                }
            }
        } else if (object instanceof Insert) {
            object = (Insert)object;
            object3.addAll(object.getColumns());
            hashMap.putAll(this.detectInsertColumnValuesNonJdbcParameters((Insert)object));
        }
        object = new HashMap(object3.size(), 1.0f);
        MetaObject metaObject = object3.iterator();
        while (metaObject.hasNext()) {
            Column column = (Column)metaObject.next();
            object.put(column.getColumnName().replaceAll("[._\\-$]", "").toUpperCase(), column.getColumnName().toUpperCase());
        }
        metaObject = SystemMetaObject.forObject((Object)boundSql.getParameterObject());
        int n = 0;
        for (ExpressionList expressionList : boundSql.getParameterMappings()) {
            String string2 = expressionList.getProperty();
            if (string2.startsWith("ew.paramNameValuePairs")) {
                ++n;
                continue;
            }
            object2 = string2.split("\\.");
            object3 = object2[((String[])object2).length - 1].replace("_", "").toUpperCase();
            try {
                object2 = hashMap2.getOrDefault(n++, this.getColumnNameByProperty((String)object3, string));
                if (object.containsKey(object3)) {
                    String string3 = (String)object.get(object3);
                    Object object5 = metaObject.getValue(string2);
                    if (object5 instanceof IEnum) {
                        object5 = ((IEnum)object5).getValue();
                    } else if (object5 instanceof Enum) {
                        object5 = this.getEnumValue((Enum)object5);
                    }
                    if (hashMap.containsKey(string3)) {
                        hashMap.put((String)object.get(object3), String.valueOf(hashMap.get(string3)).replace("?", object5 == null ? "" : object5.toString()));
                    }
                    if (object2 == null || hashMap.containsKey(object2)) continue;
                    hashMap.put((String)object2, object5);
                    continue;
                }
                if (object2 == null) continue;
                hashMap.put((String)object2, String.valueOf(metaObject.getValue(string2)));
            }
            catch (Exception exception) {
                this.logger.warn("get value error,propertyName:{},parameterMapping:{}", (Object)string2, (Object)expressionList);
            }
        }
        this.dealWithUpdateWrapper(hashMap2, hashMap, boundSql);
        return hashMap;
    }

    private List<DataChangedRecord> compareAndGetUpdatedColumnDatas(String object, OriginalDataObj list, Map<String, Object> object2) {
        object = this.ignoredTableColumns.get(((String)object).toUpperCase());
        if (list == null || ((OriginalDataObj)((Object)list)).isEmpty()) {
            list = new DataChangedRecord();
            ArrayList<DataColumnChangeResult> arrayList = new ArrayList<DataColumnChangeResult>(object2.size());
            for (Map.Entry<String, Object> entry : object2.entrySet()) {
                object2 = entry.getKey();
                if (object != null && object.contains(object2) || this.ignoreAllColumns.contains(object2)) continue;
                arrayList.add(DataColumnChangeResult.constrcutByUpdateVal((String)object2, entry.getValue()));
            }
            ((DataChangedRecord)((Object)list)).setUpdatedColumns(arrayList);
            return Collections.singletonList(list);
        }
        list = ((OriginalDataObj)((Object)list)).getOriginalDataObj();
        ArrayList<DataChangedRecord> arrayList = new ArrayList<DataChangedRecord>(list.size());
        for (DataChangedRecord dataChangedRecord : list) {
            if (!dataChangedRecord.hasUpdate((Map<String, Object>)object2, (Set<String>)object, this.ignoreAllColumns)) continue;
            arrayList.add(dataChangedRecord);
        }
        return arrayList;
    }

    private Object getEnumValue(Enum enum_) {
        Optional optional = MybatisEnumTypeHandler.findEnumValueFieldName(enum_.getClass());
        if (optional.isPresent()) {
            return SystemMetaObject.forObject((Object)enum_).getValue((String)optional.get());
        }
        return enum_;
    }

    private void dealWithUpdateWrapper(Map<Integer, String> map, Map<String, Object> map2, BoundSql object) {
        if (map.size() <= map2.size()) {
            return;
        }
        if (!(object = SystemMetaObject.forObject((Object)object.getParameterObject())).hasGetter("ew")) {
            return;
        }
        if ((object = object.getValue("ew")) instanceof UpdateWrapper || object instanceof LambdaUpdateWrapper) {
            Object object2 = object instanceof UpdateWrapper ? ((UpdateWrapper)object).getSqlSet() : ((LambdaUpdateWrapper)object).getSqlSet();
            if (object2 == null) {
                return;
            }
            object = SystemMetaObject.forObject((Object)object);
            object = (Map)object.getValue("paramNameValuePairs");
            String[] stringArray = object2.split(",");
            object2 = stringArray;
            object2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object2[i];
                if (((String[])(object3 = object3.split("=", 2))).length != 2) continue;
                String string = object3[0].trim().toUpperCase();
                object3 = object3[1].trim();
                if (!map.containsValue(string)) continue;
                object3 = object3.split("\\.");
                object3 = object3[((Object)object3).length - 1].replace("}", "");
                if ((object3 = object.get(object3)) instanceof IEnum) {
                    map2.put(string, String.valueOf(((IEnum)object3).getValue()));
                    continue;
                }
                map2.put(string, String.valueOf(object3));
            }
        }
    }

    private Map<String, String> detectInsertColumnValuesNonJdbcParameters(Insert insert) {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        Object object = insert.getSelect();
        insert = insert.getColumns();
        if (object instanceof SetOperationList) {
            object = (SetOperationList)object;
            if (CollectionUtils.isEmpty((Collection)(object = object.getSelects()))) {
                return hashMap;
            }
            if (!((object = (Select)object.get(0)) instanceof Values)) {
                return hashMap;
            }
            if ((object = (Values)object).getExpressions() instanceof ExpressionList) {
                ExpressionList expressionList = object.getExpressions();
                object = expressionList;
                object = expressionList;
                for (Expression expression : expressionList) {
                    if (!(expression instanceof RowConstructor)) continue;
                    expression = (RowConstructor)expression;
                    for (int i = 0; i < expression.size(); ++i) {
                        Object object2 = (Expression)expression.get(i);
                        if (object2 instanceof JdbcParameter) continue;
                        String string = ((Column)insert.get(i)).getColumnName();
                        object2 = object2.toString();
                        hashMap.put(string, (String)object2);
                    }
                }
            }
        }
        return hashMap;
    }

    private String getColumnNameByProperty(String string, String object) {
        TableFieldInfo tableFieldInfo = TableInfoHelper.getTableInfos().iterator();
        while (tableFieldInfo.hasNext()) {
            TableInfo tableInfo = (TableInfo)tableFieldInfo.next();
            if (!((String)object).equalsIgnoreCase(tableInfo.getTableName())) continue;
            object = tableInfo.getFieldList();
            if (CollectionUtils.isEmpty((Collection)object)) {
                return string;
            }
            object = object.iterator();
            while (object.hasNext()) {
                tableFieldInfo = (TableFieldInfo)object.next();
                if (!string.equalsIgnoreCase(tableFieldInfo.getProperty())) continue;
                return tableFieldInfo.getColumn().toUpperCase();
            }
            return string;
        }
        return string;
    }

    private Map<String, Object> buildParameterObjectMap(BoundSql object) {
        MetaObject metaObject = PluginUtils.getMetaObject((Object)object.getParameterObject());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(object.getParameterMappings().size());
        for (Object object2 : object.getParameterMappings()) {
            if ((object2 = object2.getProperty()).startsWith("ew.paramNameValuePairs")) continue;
            Object object3 = metaObject.getValue((String)object2);
            hashMap.put((String)object2, object3);
        }
        return hashMap;
    }

    private String buildOriginalData(Select select, MappedStatement object, BoundSql object2, Connection object3) {
        String string;
        block14: {
            object3 = object3.prepareStatement(select.toString());
            try {
                object = new DefaultParameterHandler((MappedStatement)object, object2.getParameterObject(), (BoundSql)object2);
                object.setParameters((PreparedStatement)object3);
                object2 = object3.executeQuery();
                object = object2.getMetaData();
                int n = object.getColumnCount();
                StringBuilder stringBuilder = new StringBuilder("[");
                int n2 = 0;
                while (object2.next()) {
                    if (this.checkTableBatchLimitExceeded(select, ++n2)) {
                        this.logger.error("batch delete limit exceed: count={}, BATCH_UPDATE_LIMIT={}", (Object)n2, (Object)this.BATCH_UPDATE_LIMIT);
                        throw DataUpdateLimitationException.DEFAULT;
                    }
                    stringBuilder.append("{");
                    for (int i = 1; i <= n; ++i) {
                        stringBuilder.append("\"").append(object.getColumnName(i)).append("\":\"");
                        Object object4 = object2.getObject(i);
                        if (object4 instanceof Clob) {
                            stringBuilder.append(DataColumnChangeResult.convertClob((Clob)object4));
                        } else {
                            stringBuilder.append(object4);
                        }
                        stringBuilder.append("\",");
                    }
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2.replace(stringBuilder2.length() - 1, stringBuilder.length(), "}");
                }
                stringBuilder.append("]");
                object2.close();
                string = stringBuilder.toString();
                if (object3 == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (object3 != null) {
                        try {
                            object3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    object3 = exception;
                    if (exception instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)object3);
                    }
                    this.logger.error("try to get record tobe deleted for selectStmt={}", (Object)select, object3);
                    return "failed to get original data";
                }
            }
            object3.close();
        }
        return string;
    }

    private OriginalDataObj buildOriginalObjectData(Map<String, Object> object, Select select, Column column, MappedStatement object2, BoundSql object3, Connection object4) {
        block11: {
            object4 = object4.prepareStatement(select.toString());
            try {
                object2 = new DefaultParameterHandler((MappedStatement)object2, object3.getParameterObject(), (BoundSql)object3);
                object2.setParameters((PreparedStatement)object4);
                object3 = object4.executeQuery();
                object2 = new LinkedList();
                int n = 0;
                while (object3.next()) {
                    if (this.checkTableBatchLimitExceeded(select, ++n)) {
                        this.logger.error("batch update limit exceed: count={}, BATCH_UPDATE_LIMIT={}", (Object)n, (Object)this.BATCH_UPDATE_LIMIT);
                        throw DataUpdateLimitationException.DEFAULT;
                    }
                    object2.add(this.prepareOriginalDataObj((Map<String, Object>)object, (ResultSet)object3, column));
                }
                object = new OriginalDataObj();
                ((OriginalDataObj)object).setOriginalDataObj((List<DataChangedRecord>)object2);
                object3.close();
                if (object4 == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (object4 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    object4 = exception;
                    if (exception instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)object4);
                    }
                    this.logger.error("try to get record tobe updated for selectStmt={}", (Object)select, object4);
                    return new OriginalDataObj();
                }
            }
            object4.close();
        }
        return object;
    }

    private boolean checkTableBatchLimitExceeded(Select object, int n) {
        if (!this.batchUpdateLimitationOpened) {
            return false;
        }
        object = (PlainSelect)object;
        if ((object = object.getFromItem()) instanceof Table) {
            object = (Table)object;
            if (!this.BATCH_UPDATE_LIMIT_MAP.containsKey(object = object.getName().toUpperCase())) {
                if (n > this.BATCH_UPDATE_LIMIT) {
                    this.logger.error("batch update limit exceed for tableName={}, BATCH_UPDATE_LIMIT={}, count={}", new Object[]{object, this.BATCH_UPDATE_LIMIT, n});
                    return true;
                }
                return false;
            }
            Integer n2 = this.BATCH_UPDATE_LIMIT_MAP.get(object);
            if (n > n2) {
                this.logger.error("batch update limit exceed for configured tableName={}, BATCH_UPDATE_LIMIT={}, count={}", new Object[]{object, n2, n});
                return true;
            }
            return false;
        }
        return n > this.BATCH_UPDATE_LIMIT;
    }

    private DataChangedRecord prepareOriginalDataObj(Map<String, Object> map, ResultSet resultSet, Column column) {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        LinkedList<DataColumnChangeResult> linkedList = new LinkedList<DataColumnChangeResult>();
        Object object = null;
        for (int i = 1; i <= n; ++i) {
            String string = resultSetMetaData.getColumnName(i).toUpperCase();
            Object object2 = map.get(string);
            object2 = object2 != null && object2.getClass().getCanonicalName().startsWith("java.") ? DataColumnChangeResult.constrcutByOriginalVal(string, resultSet.getObject(i, object2.getClass())) : DataColumnChangeResult.constrcutByOriginalVal(string, resultSet.getObject(i));
            if (column != null && string.equalsIgnoreCase(column.getColumnName())) {
                object = object2;
                continue;
            }
            linkedList.add((DataColumnChangeResult)object2);
        }
        DataChangedRecord dataChangedRecord = new DataChangedRecord();
        dataChangedRecord.setOriginalColumnDatas(linkedList);
        if (object != null) {
            dataChangedRecord.setPkColumnName(((DataColumnChangeResult)object).getColumnName());
            dataChangedRecord.setPkColumnVal(((DataColumnChangeResult)object).getOriginalValue());
        }
        return dataChangedRecord;
    }

    private Columns2SelectItemsResult buildColumns2SelectItems(String object, List<Column> object2) {
        Column column;
        if (object2 == null || object2.isEmpty()) {
            return Columns2SelectItemsResult.build(Collections.singletonList(new SelectItem((Expression)new AllColumns())), 0);
        }
        ArrayList arrayList = new ArrayList(object2.size());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            column = (Column)object2.next();
            arrayList.add(new SelectItem((Expression)column));
        }
        object2 = this.getTableInfoByTableName((String)object);
        if (object2 == null) {
            return Columns2SelectItemsResult.build(arrayList, 0);
        }
        column = new Column(object2.getKeyColumn());
        arrayList.add(new SelectItem((Expression)column));
        object = Columns2SelectItemsResult.build(arrayList, 1);
        ((Columns2SelectItemsResult)object).setPk(column);
        return object;
    }

    private String buildParameterObject(BoundSql object2) {
        Object object = object2.getParameterObject();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (object instanceof Map) {
            String string;
            Map map = (Map)object;
            int n = 1;
            boolean bl = false;
            while (map.containsKey(string = "param" + n)) {
                Object v = map.get(string);
                stringBuilder.append("\"").append(string).append("\":").append("\"").append(v).append("\",");
                bl = true;
                ++n;
            }
            if (bl) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.delete(stringBuilder2.length() - 1, stringBuilder.length());
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            for (Map.Entry entry : map.entrySet()) {
                stringBuilder.append("\"").append((String)entry.getKey()).append("\":").append("\"").append(entry.getValue()).append("\",");
            }
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.delete(stringBuilder3.length() - 1, stringBuilder.length());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        stringBuilder.append("param:").append(object);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public OperationResult processDelete(Delete object, MappedStatement object2, BoundSql boundSql, Connection connection) {
        Table table = object.getTable();
        object = object.getWhere();
        PlainSelect plainSelect = new PlainSelect();
        plainSelect.setFromItem((FromItem)table);
        plainSelect.setSelectItems(Collections.singletonList(new SelectItem((Expression)new AllColumns())));
        plainSelect.setWhere((Expression)object);
        object = this.buildOriginalData((Select)plainSelect, (MappedStatement)object2, boundSql, connection);
        object2 = new OperationResult();
        ((OperationResult)object2).setOperation("delete");
        ((OperationResult)object2).setTableName(table.getName());
        ((OperationResult)object2).setRecordStatus(((String)object).startsWith("["));
        ((OperationResult)object2).setChangedData((String)object);
        return object2;
    }

    public DataChangeRecorderInnerInterceptor setBatchUpdateLimit(int n) {
        this.BATCH_UPDATE_LIMIT = n;
        return this;
    }

    public DataChangeRecorderInnerInterceptor openBatchUpdateLimitation() {
        this.batchUpdateLimitationOpened = true;
        return this;
    }

    public DataChangeRecorderInnerInterceptor configTableLimitation(String string, int n) {
        this.BATCH_UPDATE_LIMIT_MAP.put(string.toUpperCase(), n);
        return this;
    }

    @Override
    public void setProperties(Properties stringArray) {
        if ((stringArray = stringArray.getProperty(IGNORED_TABLE_COLUMN_PROPERTIES)) == null || stringArray.trim().isEmpty()) {
            return;
        }
        String[] stringArray2 = stringArray.split(";");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray[i];
            int n2 = stringArray3.indexOf(".");
            if (n2 == -1) {
                this.logger.warn("invalid data={} for ignoredColumns, format should be TABLE_NAME1.COLUMN1,COLUMN2; TABLE2.COLUMN1,COLUMN2;", (Object)stringArray3);
                continue;
            }
            String string = stringArray3.substring(0, n2).trim().toUpperCase();
            stringArray3 = stringArray3.substring(n2 + 1).split(",");
            HashSet<String> hashSet = new HashSet<String>(stringArray3.length);
            for (String string2 : stringArray3) {
                if ((string2 = string2.trim().toUpperCase()).isEmpty()) continue;
                hashSet.add(string2);
            }
            if ("*".equals(string)) {
                this.ignoreAllColumns.addAll(hashSet);
                continue;
            }
            this.ignoredTableColumns.put(string, hashSet);
        }
    }

    public static class OperationResult {
        private String operation;
        private boolean recordStatus;
        private String tableName;
        private String changedData;
        private long cost;

        public void buildDataStr(List<DataChangedRecord> object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            object = object.iterator();
            while (object.hasNext()) {
                DataChangedRecord dataChangedRecord = (DataChangedRecord)object.next();
                stringBuilder.append(dataChangedRecord.generateUpdatedDataStr()).append(",");
            }
            if (stringBuilder.length() == 1) {
                stringBuilder.append("]");
                this.changedData = stringBuilder.toString();
                return;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.replace(stringBuilder2.length() - 1, stringBuilder.length(), "]");
            this.changedData = stringBuilder.toString();
        }

        public String toString() {
            return "{\"tableName\":\"" + this.tableName + "\",\"operation\":\"" + this.operation + "\",\"recordStatus\":\"" + this.recordStatus + "\",\"changedData\":" + this.changedData + ",\"cost(ms)\":" + this.cost + "}";
        }

        public String getOperation() {
            return this.operation;
        }

        public boolean isRecordStatus() {
            return this.recordStatus;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getChangedData() {
            return this.changedData;
        }

        public long getCost() {
            return this.cost;
        }

        public void setOperation(String string) {
            this.operation = string;
        }

        public void setRecordStatus(boolean bl) {
            this.recordStatus = bl;
        }

        public void setTableName(String string) {
            this.tableName = string;
        }

        public void setChangedData(String string) {
            this.changedData = string;
        }

        public void setCost(long l) {
            this.cost = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OperationResult)) {
                return false;
            }
            if (!((OperationResult)(object = (OperationResult)object)).canEqual(this)) {
                return false;
            }
            if (this.isRecordStatus() != ((OperationResult)object).isRecordStatus()) {
                return false;
            }
            if (this.getCost() != ((OperationResult)object).getCost()) {
                return false;
            }
            String string = this.getOperation();
            String string2 = ((OperationResult)object).getOperation();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            string = this.getTableName();
            string2 = ((OperationResult)object).getTableName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            string = this.getChangedData();
            object = ((OperationResult)object).getChangedData();
            return !(string == null ? object != null : !string.equals(object));
        }

        protected boolean canEqual(Object object) {
            return object instanceof OperationResult;
        }

        public int hashCode() {
            int n = 59 + (this.isRecordStatus() ? 79 : 97);
            long l = this.getCost();
            n = n * 59 + (int)(l >>> 32 ^ l);
            String string = this.getOperation();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            string = this.getTableName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            string = this.getChangedData();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            return n;
        }
    }

    public static class DataUpdateLimitationException
    extends MybatisPlusException {
        public static DataUpdateLimitationException DEFAULT = new DataUpdateLimitationException("\u672c\u6b21\u64cd\u4f5c \u56e0\u8d85\u8fc7\u7cfb\u7edf\u5b89\u5168\u9608\u503c \u88ab\u62e6\u622a\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");

        public DataUpdateLimitationException(String string) {
            super(string);
        }
    }

    public static class OriginalDataObj {
        private List<DataChangedRecord> originalDataObj;

        public boolean isEmpty() {
            return this.originalDataObj == null || this.originalDataObj.isEmpty();
        }

        public List<DataChangedRecord> getOriginalDataObj() {
            return this.originalDataObj;
        }

        public void setOriginalDataObj(List<DataChangedRecord> list) {
            this.originalDataObj = list;
        }

        public boolean equals(Object list) {
            if (list == this) {
                return true;
            }
            if (!(list instanceof OriginalDataObj)) {
                return false;
            }
            if (!((OriginalDataObj)((Object)(list = (OriginalDataObj)((Object)list)))).canEqual(this)) {
                return false;
            }
            List<DataChangedRecord> list2 = this.getOriginalDataObj();
            list = ((OriginalDataObj)((Object)list)).getOriginalDataObj();
            return !(list2 == null ? list != null : !((Object)list2).equals(list));
        }

        protected boolean canEqual(Object object) {
            return object instanceof OriginalDataObj;
        }

        public int hashCode() {
            List<DataChangedRecord> list = this.getOriginalDataObj();
            int n = 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.OriginalDataObj(originalDataObj=" + this.getOriginalDataObj() + ")";
        }
    }

    public static class Columns2SelectItemsResult {
        private Column pk;
        private List<SelectItem<?>> selectItems;
        private int additionalItemCount;

        public static Columns2SelectItemsResult build(List<SelectItem<?>> list, int n) {
            Columns2SelectItemsResult columns2SelectItemsResult = new Columns2SelectItemsResult();
            columns2SelectItemsResult.setSelectItems(list);
            columns2SelectItemsResult.setAdditionalItemCount(n);
            return columns2SelectItemsResult;
        }

        public Column getPk() {
            return this.pk;
        }

        public List<SelectItem<?>> getSelectItems() {
            return this.selectItems;
        }

        public int getAdditionalItemCount() {
            return this.additionalItemCount;
        }

        public void setPk(Column column) {
            this.pk = column;
        }

        public void setSelectItems(List<SelectItem<?>> list) {
            this.selectItems = list;
        }

        public void setAdditionalItemCount(int n) {
            this.additionalItemCount = n;
        }

        public boolean equals(Object list) {
            if (list == this) {
                return true;
            }
            if (!(list instanceof Columns2SelectItemsResult)) {
                return false;
            }
            if (!((Columns2SelectItemsResult)((Object)(list = (Columns2SelectItemsResult)((Object)list)))).canEqual(this)) {
                return false;
            }
            if (this.getAdditionalItemCount() != ((Columns2SelectItemsResult)((Object)list)).getAdditionalItemCount()) {
                return false;
            }
            Object object = this.getPk();
            Column column = ((Columns2SelectItemsResult)((Object)list)).getPk();
            if (object == null ? column != null : !object.equals(column)) {
                return false;
            }
            object = this.getSelectItems();
            list = ((Columns2SelectItemsResult)((Object)list)).getSelectItems();
            return !(object == null ? list != null : !object.equals(list));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Columns2SelectItemsResult;
        }

        public int hashCode() {
            int n = 59 + this.getAdditionalItemCount();
            Object object = this.getPk();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            object = this.getSelectItems();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            return n;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.Columns2SelectItemsResult(pk=" + this.getPk() + ", selectItems=" + this.getSelectItems() + ", additionalItemCount=" + this.getAdditionalItemCount() + ")";
        }
    }

    public static class DataChangedRecord {
        private String pkColumnName;
        private Object pkColumnVal;
        private List<DataColumnChangeResult> originalColumnDatas;
        private List<DataColumnChangeResult> updatedColumns;

        public boolean hasUpdate(Map<String, Object> map, Set<String> set, Set<String> set2) {
            if (this.originalColumnDatas == null) {
                return true;
            }
            boolean bl = false;
            this.updatedColumns = new ArrayList<DataColumnChangeResult>(this.originalColumnDatas.size());
            for (DataColumnChangeResult dataColumnChangeResult : this.originalColumnDatas) {
                Object object = dataColumnChangeResult.getColumnName().toUpperCase();
                if (set != null && set.contains(object) || set2.contains(object) || !dataColumnChangeResult.isDataChanged(object = map.get(object))) continue;
                bl = true;
                dataColumnChangeResult.setUpdateValue(object);
                this.updatedColumns.add(dataColumnChangeResult);
            }
            return bl;
        }

        public String generateUpdatedDataStr() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            if (this.pkColumnName != null) {
                DataChangedRecord dataChangedRecord = this;
                stringBuilder.append("\"").append(this.pkColumnName).append("\":").append("\"").append(dataChangedRecord.convertDoubleQuotes(dataChangedRecord.pkColumnVal)).append("\",");
            }
            for (DataColumnChangeResult dataColumnChangeResult : this.updatedColumns) {
                stringBuilder.append(dataColumnChangeResult.generateDataStr());
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.replace(stringBuilder2.length() - 1, stringBuilder.length(), "}");
            return stringBuilder.toString();
        }

        public String convertDoubleQuotes(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString().replace("\"", "\\\"");
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public Object getPkColumnVal() {
            return this.pkColumnVal;
        }

        public List<DataColumnChangeResult> getOriginalColumnDatas() {
            return this.originalColumnDatas;
        }

        public List<DataColumnChangeResult> getUpdatedColumns() {
            return this.updatedColumns;
        }

        public void setPkColumnName(String string) {
            this.pkColumnName = string;
        }

        public void setPkColumnVal(Object object) {
            this.pkColumnVal = object;
        }

        public void setOriginalColumnDatas(List<DataColumnChangeResult> list) {
            this.originalColumnDatas = list;
        }

        public void setUpdatedColumns(List<DataColumnChangeResult> list) {
            this.updatedColumns = list;
        }

        public boolean equals(Object list) {
            if (list == this) {
                return true;
            }
            if (!(list instanceof DataChangedRecord)) {
                return false;
            }
            if (!((DataChangedRecord)((Object)(list = (DataChangedRecord)((Object)list)))).canEqual(this)) {
                return false;
            }
            List<DataColumnChangeResult> list2 = this.getPkColumnName();
            List<DataColumnChangeResult> list3 = ((DataChangedRecord)((Object)list)).getPkColumnName();
            if (list2 == null ? list3 != null : !((Object)list2).equals(list3)) {
                return false;
            }
            list2 = this.getPkColumnVal();
            list3 = ((DataChangedRecord)((Object)list)).getPkColumnVal();
            if (list2 == null ? list3 != null : !((Object)list2).equals(list3)) {
                return false;
            }
            list2 = this.getOriginalColumnDatas();
            list3 = ((DataChangedRecord)((Object)list)).getOriginalColumnDatas();
            if (list2 == null ? list3 != null : !((Object)list2).equals(list3)) {
                return false;
            }
            list2 = this.getUpdatedColumns();
            list = ((DataChangedRecord)((Object)list)).getUpdatedColumns();
            return !(list2 == null ? list != null : !((Object)list2).equals(list));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DataChangedRecord;
        }

        public int hashCode() {
            String string = this.getPkColumnName();
            int n = 59 + (string == null ? 43 : string.hashCode());
            List<DataColumnChangeResult> list = this.getPkColumnVal();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            list = this.getOriginalColumnDatas();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            list = this.getUpdatedColumns();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataChangedRecord(pkColumnName=" + this.getPkColumnName() + ", pkColumnVal=" + this.getPkColumnVal() + ", originalColumnDatas=" + this.getOriginalColumnDatas() + ", updatedColumns=" + this.getUpdatedColumns() + ")";
        }
    }

    public static class DataColumnChangeResult {
        private String columnName;
        private Object originalValue;
        private Object updateValue;

        public boolean isDataChanged(Object object) {
            if (!Objects.equals(this.originalValue, object)) {
                if (this.originalValue instanceof Clob) {
                    String string = DataColumnChangeResult.convertClob((Clob)this.originalValue);
                    this.setOriginalValue(string);
                    return !string.equals(object);
                }
                if (this.originalValue instanceof Comparable) {
                    Comparable comparable = (Comparable)this.originalValue;
                    object = (Comparable)object;
                    try {
                        return object == null || comparable.compareTo(object) != 0;
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }
                return true;
            }
            return false;
        }

        public static String convertClob(Clob object) {
            try {
                return object.getSubString(0L, (int)object.length());
            }
            catch (Exception exception) {
                Object object2;
                block11: {
                    object = object.getCharacterStream();
                    try {
                        int n;
                        object2 = new char[64];
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((n = ((Reader)object).read((char[])object2)) != -1) {
                            stringBuilder.append((char[])object2, 0, n);
                        }
                        object2 = stringBuilder.toString();
                        if (object == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (object != null) {
                                try {
                                    ((Reader)object).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception2) {
                            return "unknown clobObj";
                        }
                    }
                    ((Reader)object).close();
                }
                return object2;
            }
        }

        public static DataColumnChangeResult constrcutByUpdateVal(String string, Object object) {
            DataColumnChangeResult dataColumnChangeResult = new DataColumnChangeResult();
            dataColumnChangeResult.setColumnName(string);
            dataColumnChangeResult.setUpdateValue(object);
            return dataColumnChangeResult;
        }

        public static DataColumnChangeResult constrcutByOriginalVal(String string, Object object) {
            DataColumnChangeResult dataColumnChangeResult = new DataColumnChangeResult();
            dataColumnChangeResult.setColumnName(string);
            dataColumnChangeResult.setOriginalValue(object);
            return dataColumnChangeResult;
        }

        public String generateDataStr() {
            StringBuilder stringBuilder = new StringBuilder();
            DataColumnChangeResult dataColumnChangeResult = this;
            DataColumnChangeResult dataColumnChangeResult2 = this;
            stringBuilder.append("\"").append(this.columnName).append("\":").append("\"").append(dataColumnChangeResult.convertDoubleQuotes(dataColumnChangeResult.originalValue)).append("->").append(dataColumnChangeResult2.convertDoubleQuotes(dataColumnChangeResult2.updateValue)).append("\",");
            return stringBuilder.toString();
        }

        public String convertDoubleQuotes(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString().replace("\"", "\\\"");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Object getOriginalValue() {
            return this.originalValue;
        }

        public Object getUpdateValue() {
            return this.updateValue;
        }

        public void setColumnName(String string) {
            this.columnName = string;
        }

        public void setOriginalValue(Object object) {
            this.originalValue = object;
        }

        public void setUpdateValue(Object object) {
            this.updateValue = object;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DataColumnChangeResult)) {
                return false;
            }
            if (!((DataColumnChangeResult)(object = (DataColumnChangeResult)object)).canEqual(this)) {
                return false;
            }
            Object object2 = this.getColumnName();
            Object object3 = ((DataColumnChangeResult)object).getColumnName();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            object2 = this.getOriginalValue();
            object3 = ((DataColumnChangeResult)object).getOriginalValue();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            object2 = this.getUpdateValue();
            object = ((DataColumnChangeResult)object).getUpdateValue();
            return !(object2 == null ? object != null : !object2.equals(object));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DataColumnChangeResult;
        }

        public int hashCode() {
            String string = this.getColumnName();
            int n = 59 + (string == null ? 43 : string.hashCode());
            Object object = this.getOriginalValue();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            object = this.getUpdateValue();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            return n;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataColumnChangeResult(columnName=" + this.getColumnName() + ", originalValue=" + this.getOriginalValue() + ", updateValue=" + this.getUpdateValue() + ")";
        }
    }
}

