/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.system;

import cn.iinti.majora3.entity.CommonRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.resource.NoResourceFoundException;
import proguard.annotation.Keep;

@RestControllerAdvice
@Keep
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"cn.iinti.majora3.system.GlobalExceptionHandler");

    @ExceptionHandler(value={MethodArgumentNotValidException.class, IllegalArgumentException.class})
    public CommonRes<String> handleMethodArgumentNotValid(Exception exception) {
        if (exception instanceof MethodArgumentNotValidException && ((MethodArgumentNotValidException)exception).getBindingResult().getFieldError() != null) {
            return CommonRes.failed("\u53c2\u6570\u9519\u8bef\uff1a" + ((MethodArgumentNotValidException)exception).getBindingResult().getFieldError().getDefaultMessage());
        }
        log.error("GlobalException", (Throwable)exception);
        return CommonRes.failed("\u53c2\u6570\u9519\u8bef\uff1a" + exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public CommonRes<String> handleUncaughtException(Exception exception) {
        if (exception instanceof NoResourceFoundException) {
            throw exception;
        }
        if (this.isClientAbortException(exception)) {
            log.info("client abort", (Throwable)exception);
            return CommonRes.failed("unexpected error:" + exception.getMessage());
        }
        log.error("unexpected exception:", (Throwable)exception);
        return CommonRes.failed("unexpected error:" + exception.getMessage());
    }

    private boolean isClientAbortException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof HttpMessageNotReadableException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

