/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.service.base.alert;

import cn.iinti.majora3.0O.oOoOoOoOOo.Oo;
import cn.iinti.majora3.0O.oOoOoOoOOo.oO;
import cn.iinti.majora3.service.base.alert.events.MetricMonitorConfig;
import cn.iinti.majora3.service.base.metric.MetricEnums;
import cn.iinti.majora3.service.base.metric.MetricVo;
import groovy.lang.Closure;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.support.CronExpression;

public class MetricMonitorHandle {
    private Oo mql;
    private CronExpression cron;
    private LocalDateTime start;
    private LocalDateTime end;
    private MetricEnums.MetricAccuracy accuracy;
    private Closure<?> callback;
    private LocalDateTime lastRun;
    private Predicate<List<MetricVo>> timeFilter = object -> {
        object = (MetricVo)object.get(0);
        if (this.start != null && ((MetricVo)object).getCreateTime().isBefore(this.start)) {
            return false;
        }
        return this.end == null || !((MetricVo)object).getCreateTime().isAfter(this.end);
    };

    public void evaluate(cn.iinti.majora3.service.base.metric.Oo object, boolean bl) {
        if (!bl && !this.isCronRunTime()) {
            return;
        }
        if (this.accuracy == null) {
            this.accuracy = MetricEnums.MetricAccuracy.hours;
        }
        if (this.start != null) {
            this.trimAccuracy();
        }
        this.lastRun = LocalDateTime.now();
        object = this.mql.oO(this.accuracy, (cn.iinti.majora3.service.base.metric.Oo)object);
        object = this.filterAndMerge((Map<String, oO.oO>)object);
        object = new MetricMonitorConfig.MetricData((Map<String, List<MetricVo>>)object);
        this.callback.rehydrate(object, this.callback.getOwner(), this.callback.getThisObject()).call();
    }

    private void trimAccuracy() {
        if (this.accuracy == MetricEnums.MetricAccuracy.days) {
            return;
        }
        if (this.start.isBefore(LocalDateTime.now().minusDays(30L))) {
            this.accuracy = MetricEnums.MetricAccuracy.days;
            return;
        }
        if (this.accuracy == MetricEnums.MetricAccuracy.hours) {
            return;
        }
        if (this.start.isBefore(LocalDateTime.now().minusDays(1L))) {
            this.accuracy = MetricEnums.MetricAccuracy.hours;
        }
    }

    private Map<String, List<MetricVo>> filterAndMerge(Map<String, oO.oO> map) {
        HashMap<String, List<MetricVo>> hashMap = new HashMap<String, List<MetricVo>>();
        map.forEach((string, list) -> {
            list = this.filter(((oO.oO)((Object)list)).oO);
            list = this.merge((TreeMap<String, List<MetricVo>>)((Object)list));
            hashMap.put((String)string, (List<MetricVo>)list);
        });
        return hashMap;
    }

    private List<MetricVo> merge(TreeMap<String, List<MetricVo>> treeMap) {
        Set set = treeMap.values().stream().flatMap(list -> list.stream().map(MetricVo::toTagId)).collect(Collectors.toSet());
        return set.stream().map(object2 -> {
            if ((treeMap = ((TreeMap)treeMap).values().stream().map(arg_0 -> MetricMonitorHandle.lambda$merge$4((String)object2, arg_0)).filter(Objects::nonNull).toList()).isEmpty()) {
                return null;
            }
            object2 = (MetricVo)treeMap.get(0);
            MetricVo metricVo = MetricVo.cloneMetricVo((MetricVo)object2);
            switch (((MetricVo)object2).getType()) {
                case COUNTER: {
                    metricVo.setValue(treeMap.stream().map(MetricVo::getValue).reduce(0.0, Double::sum));
                    break;
                }
                case GAUGE: {
                    Object object3 = treeMap;
                    metricVo.setValue(((MetricVo)object3.get(object3.size() - 1)).getValue());
                    break;
                }
                case TIMER: {
                    object2 = ((MetricVo)object2).getTags().get(MetricMonitorHandle.__deObfuscate(new long[]{-1381318041839242625L, -6553751387539850336L, -4450907089676388782L}));
                    if (StringUtils.isBlank((CharSequence)object2) || ((String)object2).equals(MetricEnums.TimeSubType.MAX.metricKey)) {
                        metricVo.setValue(treeMap.stream().map(MetricVo::getValue).reduce(0.0, Double::max));
                        break;
                    }
                    if (!((String)object2).equals(MetricEnums.TimeSubType.TIME.metricKey) && !((String)object2).equals(MetricEnums.TimeSubType.COUNT.metricKey)) break;
                    metricVo.setValue(treeMap.stream().map(MetricVo::getValue).reduce(0.0, Double::sum));
                }
            }
            return metricVo;
        }).filter(Objects::nonNull).toList();
    }

    private TreeMap<String, List<MetricVo>> filter(TreeMap<String, List<MetricVo>> treeMap) {
        TreeMap<String, List<MetricVo>> treeMap2 = new TreeMap<String, List<MetricVo>>();
        treeMap.forEach((string, list) -> {
            if (this.timeFilter.test((List<MetricVo>)list)) {
                treeMap2.put((String)string, (List<MetricVo>)list);
            }
        });
        return treeMap2;
    }

    private boolean isCronRunTime() {
        if (this.lastRun == null) {
            return true;
        }
        LocalDateTime localDateTime = (LocalDateTime)this.cron.next((Temporal)this.lastRun);
        if (localDateTime == null) {
            return false;
        }
        return !localDateTime.isAfter(LocalDateTime.now());
    }

    public void setMql(Oo oo) {
        this.mql = oo;
    }

    public void setCron(CronExpression cronExpression) {
        this.cron = cronExpression;
    }

    public void setStart(LocalDateTime localDateTime) {
        this.start = localDateTime;
    }

    public void setEnd(LocalDateTime localDateTime) {
        this.end = localDateTime;
    }

    public void setAccuracy(MetricEnums.MetricAccuracy metricAccuracy) {
        this.accuracy = metricAccuracy;
    }

    public void setCallback(Closure<?> closure) {
        this.callback = closure;
    }

    public void setLastRun(LocalDateTime localDateTime) {
        this.lastRun = localDateTime;
    }

    public void setTimeFilter(Predicate<List<MetricVo>> predicate) {
        this.timeFilter = predicate;
    }

    private static /* synthetic */ MetricVo lambda$merge$4(String string, List list) {
        return list.stream().filter((? super T metricVo) -> metricVo.toTagId().equals(string)).findAny().orElse(null);
    }

    public static String __deObfuscate(long[] lArray) {
        int n = lArray.length;
        byte[] byArray = new byte[8 * (n - 1)];
        long l = lArray[0];
        Random random = new Random(l);
        for (int i = 1; i < n; ++i) {
            long l2 = random.nextLong();
            long l3 = lArray[i] ^ l2;
            int n2 = 8 * (i - 1);
            int n3 = Math.min(byArray.length, n2 + 8);
            while (n2 < n3) {
                byArray[n2] = (byte)l3;
                l3 >>= 8;
                ++n2;
            }
        }
        String string = new String(byArray, StandardCharsets.UTF_8);
        int n4 = string.indexOf(0);
        if (-1 == n4) {
            return string;
        }
        return string.substring(0, n4);
    }
}

