/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3;

import cn.iinti.majora3.0O.oOOoOooOOo.OoOoOo;
import cn.iinti.majora3.0O.oOOoOooOOo.oOOo;
import cn.iinti.majora3.0O.oOOooOOo.oO;
import cn.iinti.majora3.entity.type.JSONTypeHandler;
import cn.iinti.majora3.service.base.BroadcastService;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.util.IOUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import proguard.annotation.Keep;

@SpringBootApplication
@EnableAspectJAutoProxy
@MapperScan(value={"cn.iinti.majora3.mapper"})
@EnableScheduling
@Configuration
@Keep
public class MajoraV3Main
implements CommandLineRunner,
ApplicationListener<WebServerInitializedEvent> {
    private static final cn.iinti.majora3.0O.OoOooOoOOo.oO shardThread = new cn.iinti.majora3.0O.OoOooOoOOo.oO("ShardThread").oOoOOo().oO();
    @Resource
    private DataSource dataSource;
    @Resource
    private oO configService;
    private static final Consumer<Throwable> defaultErrorHandle = throwable -> {
        throwable.printStackTrace(System.err);
        System.exit(1);
    };

    @Scheduled(fixedRate=600000L)
    public void reloadConfig() {
        this.configService.Oo();
    }

    @PostConstruct
    public void init() {
        try {
            cn.iinti.majora3.0O.OooOOoOo.oO.oO(this.dataSource);
        }
        catch (Throwable throwable) {
            System.out.println("upgrade failed,please contact iint business support");
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
        this.reloadConfig();
        BroadcastService.oO(BroadcastService.Topic.CONFIG, this::reloadConfig);
    }

    public void onApplicationEvent(@Nonnull WebServerInitializedEvent webServerInitializedEvent) {
        cn.iinti.majora3.0O.OooOOoOo.oO.oO(webServerInitializedEvent);
    }

    @Keep
    public static void main(String[] object) {
        object = Lists.newArrayList((Object[])object);
        object.add("--env.versionCode=1");
        object.add("--env.versionName=3.0");
        boolean bl = object.stream().anyMatch(string -> string.contains("--LogbackDir"));
        if (!bl) {
            File file = cn.iinti.majora3.0O.OooOOoOo.oO.oOoOOo;
            if (file.getName().equals("conf")) {
                file = file.getParentFile();
            } else if (file.toString().endsWith("build/resources/main")) {
                file = file.getParentFile().getParentFile();
            }
            object.add("--LogbackDir=" + new File(file, "logs").getAbsolutePath());
        }
        MajoraV3Main.springContextParamSetup((List<String>)object);
        Iterator iterator = MajoraV3Main.class.getClassLoader().getResourceAsStream("addition.txt");
        if (iterator != null) {
            iterator = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults().splitToList((CharSequence)IOUtils.toString((InputStream)((Object)iterator), (Charset)StandardCharsets.UTF_8));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (object.contains(string2)) continue;
                object.add(string2);
            }
        }
        Object object2 = object;
        MajoraV3Main.runApp((List<String>)object2, arg_0 -> MajoraV3Main.lambda$main$1((List)object2, arg_0));
    }

    private static void runApp(List<String> list, Consumer<Throwable> consumer) {
        try {
            SpringApplication.run(MajoraV3Main.class, (String[])list.toArray(new String[0]));
            return;
        }
        catch (Throwable throwable) {
            consumer.accept(throwable);
            return;
        }
    }

    private static void springContextParamSetup(List<String> list) {
        list.add("--spring.main.allow-circular-references=true");
        if (cn.iinti.majora3.0O.OooOOoOo.oO.OooOOo) {
            list.add("--spring.docker.compose.file=classpath:develop-majora/docker-compose-local.yaml");
            list.add("--spring.docker.compose.lifecycle-management=start-only");
        }
        MajoraV3Main.checkAddPram(list, "spring.application.name", "majora");
        MajoraV3Main.checkAddPram(list, "management.endpoints.web.exposure.include", "*");
        MajoraV3Main.checkAddPram(list, "management.endpoints.web.base-path", "/majora-api/actuator");
        MajoraV3Main.checkAddPram(list, "management.metrics.tags.application", "majora");
        MajoraV3Main.checkAddPram(list, "mybatis-plus.configuration.default-enum-type-handler", EnumOrdinalTypeHandler.class.getName());
        MajoraV3Main.checkAddPram(list, "mybatis-plus.type-handlers-package", JSONTypeHandler.class.getPackageName());
        MajoraV3Main.checkAddPram(list, "server.compression.enabled", "true");
        MajoraV3Main.checkAddPram(list, "server.compression.mime-types", "application/json,application/xml,text/html,text/xml,text/plain,application/javascript,text/css");
        MajoraV3Main.checkAddPram(list, "server.compression.min-response-size", "10");
        MajoraV3Main.checkAddPram(list, "server.compression.excluded-user-agents", "gozilla,traviata");
        MajoraV3Main.checkAddPram(list, "spring.servlet.multipart.max-file-size", "100MB");
        MajoraV3Main.checkAddPram(list, "spring.servlet.multipart.max-request-size", "102MB");
        MajoraV3Main.checkAddPram(list, "spring.jackson.date-format", "yyyy-MM-dd HH:mm:ss");
        MajoraV3Main.checkAddPram(list, "spring.jackson.time-zone", "GMT+8");
        MajoraV3Main.checkAddPram(list, "spring.datasource.driver-class-name", "com.mysql.cj.jdbc.Driver");
    }

    private static void checkAddPram(List<String> list, String string, String string2) {
        for (String string3 : list) {
            if (!StringUtils.containsIgnoreCase((CharSequence)string3, (CharSequence)string)) continue;
            return;
        }
        list.add("--" + string + "=" + string2);
    }

    public void run(String ... stringArray) {
        OoOoOo.oO();
        shardThread.oO(oOOo::oO);
    }

    public static cn.iinti.majora3.0O.OoOooOoOOo.oO getShardThread() {
        return shardThread;
    }

    private static /* synthetic */ void lambda$main$1(List list, Throwable throwable) {
        if (cn.iinti.majora3.0O.OooOOoOo.oO.OooOOo && StringUtils.contains((CharSequence)throwable.getMessage(), (CharSequence)"Docker is not running")) {
            list.add("--spring.docker.compose.enabled=false");
            throwable.printStackTrace(System.err);
            MajoraV3Main.runApp(list, defaultErrorHandle);
            return;
        }
        defaultErrorHandle.accept(throwable);
    }
}

